package com.zoyi.channel.plugin.android.model.etc;

import com.zoyi.channel.plugin.android.event.PushBus;

/**
 * Created by jerry on 2018. 2. 22..
 */

public class PushEvent {

  private String chatId;
  private String avatarUrl;
  private String name;
  private String message;

  public PushEvent(PushBus pushBus) {
    this.chatId = pushBus.getUserChat().getId();
    this.name = pushBus.getProfileEntity().getName();
    this.avatarUrl = pushBus.getProfileEntity().getAvatarUrl();
    this.message = pushBus.getMessage();
  }

  public String getChatId() {
    return chatId;
  }

  public String getAvatarUrl() {
    return avatarUrl;
  }

  public String getMessage() {
    return message;
  }

  public String getName() {
    return name;
  }
}
