package com.zoyi.channel.plugin.android.activity.settings;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.SwitchCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;

public class SettingsChatFragment extends Fragment
    implements CompoundButton.OnCheckedChangeListener {

  private Context context;

  private boolean completed = false;

  @Nullable
  @Override
  public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
    return inflater.inflate(R.layout.ch_plugin_fragment_settings_chat, container, false);
  }

  @Override
  public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
    super.onViewCreated(view, savedInstanceState);

    context = getActivity();

    completed = PrefSupervisor.isShownClosedChat(context);

    SwitchCompat switchCompleted = (SwitchCompat) view.findViewById(R.id.sw_show_closed_chat);
    switchCompleted.setChecked(completed);
    switchCompleted.setOnCheckedChangeListener(this);

    SwitchCompat switchAlarm = (SwitchCompat) view.findViewById(R.id.sw_enable_alarm);
    switchAlarm.setChecked(PrefSupervisor.isEnabledPushAlarm(context));
    switchAlarm.setOnCheckedChangeListener(this);
  }

  @Override
  public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
    int id = buttonView.getId();

    if (id == R.id.sw_show_closed_chat) {
      handleShowClosedChat(isChecked);
    }
    if (id == R.id.sw_enable_alarm) {
      PrefSupervisor.setPushAlarm(context, isChecked);
    }
  }

  private void handleShowClosedChat(boolean isChecked) {
    if (completed == isChecked) {
      getActivity().setResult(Activity.RESULT_CANCELED);
    } else {
      getActivity().setResult(Const.RESULT_CHAT_OPTION_CHANGED);
    }
    PrefSupervisor.setShowClosedChat(context, isChecked);
  }
}
