package com.zoyi.channel.plugin.android.model.rest;

import android.graphics.Color;
import android.os.Parcel;
import android.os.Parcelable;

import com.zoyi.channel.plugin.android.model.interfaces.PersonEntity;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;

/**
 * Created by mika on 2016. 12. 8..
 */
public class Bot implements PersonEntity, Parcelable {

  private String id;
  private String channelId;
  private String name;
  private Long createdAt;
  private String avatarUrl;
  private String initial;
  private String color;

  public Bot() {}

  @Override
  public String getName() {
    return name;
  }

  @Override
  public String getPersonType() {
    return "Bot";
  }

  @Override
  public int getBackgroundColor() {
    try {
      return Color.parseColor(color);
    } catch (Exception ex) {
    }
    return Color.BLACK;
  }

  @Override
  public int getTextColor() {
    return Color.WHITE;
  }

  @Override
  public String getAvatarUrl() {
    return avatarUrl;
  }

  @Override
  public String getInitial() {
    return initial;
  }

  @Override
  public boolean isHost() {
    return true;
  }

  public String getId() {
    return id;
  }

  public String getChannelId() {
    return channelId;
  }

  public Long getCreatedAt() {
    return createdAt;
  }

  public String getColor() {
    return color;
  }

  public final static String CLASSNAME = "Bot";

  protected Bot(Parcel in) {
    id = in.readString();
    channelId = in.readString();
    name = in.readString();
    if (in.readByte() == 0) {
      createdAt = null;
    } else {
      createdAt = in.readLong();
    }
    avatarUrl = in.readString();
    initial = in.readString();
    color = in.readString();
  }

  public static final Creator<Bot> CREATOR = new Creator<Bot>() {
    @Override
    public Bot createFromParcel(Parcel in) {
      return new Bot(in);
    }

    @Override
    public Bot[] newArray(int size) {
      return new Bot[size];
    }
  };

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(Parcel dest, int flags) {
    dest.writeString(id);
    dest.writeString(channelId);
    dest.writeString(name);
    if (createdAt == null) {
      dest.writeByte((byte) 0);
    } else {
      dest.writeByte((byte) 1);
      dest.writeLong(createdAt);
    }
    dest.writeString(avatarUrl);
    dest.writeString(initial);
    dest.writeString(color);
  }
}

