/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.base;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.ChannelModelBus;
import com.zoyi.channel.plugin.android.event.ChatCounterBus;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.TypingBus;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.interfaces.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.util.ProgressHelper;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;

public class BaseActivity
extends AppCompatActivity {
    private BigBar bigBar;
    private ProgressDialog progressDialog;
    private Subscription subscription;
    protected static final int PERMISSION_READ_STORAGE = 1;
    protected static final int PERMISSION_WRITE_STORAGE = 2;
    protected static final int PERMISSION_CAMERA = 3;
    protected static final int PERMISSION_CALL_PHONE = 4;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.finish();
            return;
        }
        this.subscription = RxBus.observable().onBackpressureBuffer().observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Object>(){

            public void call(Object o) {
                if (o instanceof CommandBus) {
                    CommandBus commandBus = (CommandBus)o;
                    BaseActivity.this.receiveCommand(commandBus.getCommand(), commandBus.getObject());
                }
                if (o instanceof ChannelModelBus) {
                    ChannelModelBus channelModelBus = (ChannelModelBus)o;
                    BaseActivity.this.receiveData(channelModelBus.getChannelModel(), channelModelBus.isUpsert());
                }
                if (o instanceof ChatCounterBus) {
                    ChatCounterBus chatCounterBus = (ChatCounterBus)o;
                    BaseActivity.this.receiveChatCounter(chatCounterBus.getCounter());
                }
                if (o instanceof TypingBus) {
                    TypingBus typingBus = (TypingBus)o;
                    BaseActivity.this.receiveTyping(typingBus.getTyping());
                }
            }
        });
        this.overridePendingTransition(this.getEnterAnimOfCreate(), this.getExistAnimOfCreate());
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(this.getEnterAnimOfFinish(), this.getExistAnimOfFinish());
    }

    protected void onDestroy() {
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
        super.onDestroy();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == 21) {
            this.setResult(resultCode);
            this.finish();
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    protected void init(int layoutId) {
        this.setContentView(layoutId);
        this.bigBar = (BigBar)this.findViewById(R.id.big_bar);
    }

    public int getBackgroundColor() {
        Plugin plugin = ChannelStore.getPlugin();
        if (plugin != null) {
            return plugin.getBackgroundColor();
        }
        return -16777216;
    }

    public int getTextColor() {
        Plugin plugin = ChannelStore.getPlugin();
        if (plugin != null) {
            return plugin.getTextColor();
        }
        return -1;
    }

    protected BigBar getBigBar() {
        return this.bigBar;
    }

    protected void setStatusBarColor(int color) {
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                this.getWindow().setStatusBarColor(Utils.addBlackMask(color));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void optionClicked(MenuButton.ActionType actionType) {
        switch (actionType) {
            case BACK: 
            case EXIT: {
                this.onBackPressed();
            }
        }
    }

    public void hideKeyboard(EditText editText) {
        InputMethodManager inputManager = (InputMethodManager)this.getSystemService("input_method");
        if (inputManager != null) {
            inputManager.hideSoftInputFromWindow(editText.getWindowToken(), 2);
        }
    }

    protected Integer getRequestCode() {
        if (this.getIntent() != null) {
            return this.getIntent().getIntExtra("REQUEST_CODE_INTENT_KEY", Integer.MIN_VALUE);
        }
        return null;
    }

    public void showProgress(String message) {
        this.hideProgress();
        this.progressDialog = ProgressHelper.show((Context)this, message);
    }

    public void hideProgress() {
        try {
            if (this.progressDialog != null && this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void receiveCommand(Command command, Object object) {
    }

    public void receiveData(ChannelModel channelModel, boolean upsert) {
    }

    public void receiveChatCounter(int count) {
    }

    public void receiveTyping(Typing typing) {
    }

    @TargetApi(value=23)
    private String getPermission(int requestCode) {
        switch (requestCode) {
            case 1: {
                return "android.permission.READ_EXTERNAL_STORAGE";
            }
            case 2: {
                return "android.permission.WRITE_EXTERNAL_STORAGE";
            }
            case 3: {
                return "android.permission.CAMERA";
            }
            case 4: {
                return "android.permission.CALL_PHONE";
            }
        }
        return "";
    }

    protected boolean checkPermission(int ... requestCodes) {
        if (requestCodes.length == 0 || Build.VERSION.SDK_INT < 23) {
            return true;
        }
        String[] requestStr = new String[requestCodes.length];
        int count = 0;
        for (int i = 0; i < requestCodes.length; ++i) {
            requestStr[i] = this.getPermission(requestCodes[i]);
            if (ContextCompat.checkSelfPermission((Context)this, (String)requestStr[i]) != 0) continue;
            ++count;
        }
        if (count == requestCodes.length) {
            return true;
        }
        ActivityCompat.requestPermissions((Activity)this, (String[])requestStr, (int)requestCodes[0]);
        return false;
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] results) {
        for (int result : results) {
            if (result == 0) continue;
            this.permissionRejected(requestCode);
            return;
        }
        this.permissionAccepted(requestCode);
    }

    protected void permissionAccepted(int requestCode) {
    }

    protected void permissionRejected(int requestCode) {
    }

    @AnimRes
    protected int getEnterAnimOfCreate() {
        return R.anim.ch_plugin_slide_in_right;
    }

    @AnimRes
    protected int getExistAnimOfCreate() {
        return R.anim.ch_plugin_idle;
    }

    @AnimRes
    protected int getEnterAnimOfFinish() {
        return R.anim.ch_plugin_idle;
    }

    @AnimRes
    protected int getExistAnimOfFinish() {
        return R.anim.ch_plugin_slide_out_right;
    }
}

