/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import com.splunk.mint.DataSaver;
import com.splunk.mint.EnumActionType;
import com.splunk.mint.Logger;
import com.splunk.mint.Mint;
import com.splunk.mint.MintUrls;
import com.splunk.mint.NetSenderResponse;
import com.splunk.mint.Properties;
import com.splunk.mint.SequentialExecutor;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;

class NetSender {
    private static final SequentialExecutor executor = new SequentialExecutor();

    private NetSender() {
    }

    public static void send(final String data, final boolean saveOnFail) {
        executor.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                NetSender.sendBlocking(null, data, saveOnFail);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized NetSenderResponse sendBlocking(String url, String data, boolean saveOnFail) {
        if (!Properties.USER_OPTEDOUT) {
            NetSenderResponse mNetSenderResponse = new NetSenderResponse(url, data);
            if (data == null) {
                mNetSenderResponse.setException(new IllegalArgumentException("null data!"));
                if (Mint.mintCallback != null) {
                    Mint.mintCallback.netSenderResponse(mNetSenderResponse);
                }
                Logger.logInfo(mNetSenderResponse.toString());
                return mNetSenderResponse;
            }
            if (Properties.hecEnabled) {
                url = MintUrls.getURL();
                mNetSenderResponse.setUrl(url);
            } else if (url == null) {
                int numOfErrors = 0;
                int numOfActions = 0;
                int numAllActions = NetSender.findAllActions(data);
                if (numAllActions > 0) {
                    numOfErrors = NetSender.findAllErrors(data);
                    numOfActions = numAllActions - numOfErrors;
                }
                url = MintUrls.getURL(numOfErrors, numOfActions);
                mNetSenderResponse.setUrl(url);
            }
            Logger.logInfo("NetSender: Sending data to url: " + url);
            ByteArrayOutputStream baos = null;
            DeflaterOutputStream gos = null;
            HttpURLConnection conn = null;
            try {
                URL urlToSend = new URL(url);
                conn = (HttpURLConnection)urlToSend.openConnection();
                conn.setReadTimeout(10000);
                conn.setConnectTimeout(10000);
                conn.setDoInput(true);
                conn.setDoOutput(true);
                if (conn instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)conn).setRequestMethod("POST");
                } else {
                    conn.setRequestMethod("POST");
                }
                if (Properties.hecEnabled) {
                    conn.setRequestProperty("Content-Encoding", "gzip");
                    conn.setRequestProperty("Authorization", "Splunk " + Properties.hecToken);
                } else {
                    conn.setRequestProperty("Accept-Encoding", "gzip");
                    conn.setRequestProperty("Content-Type", "application/x-gzip");
                }
                baos = new ByteArrayOutputStream();
                gos = new GZIPOutputStream(baos){
                    {
                        this.def.setLevel(9);
                    }
                };
                gos.write(data.getBytes());
                gos.close();
                OutputStream os = conn.getOutputStream();
                os.write(baos.toByteArray());
                os.close();
                int responseCode = conn.getResponseCode();
                mNetSenderResponse.setResponseCode(responseCode);
                if (responseCode >= 400) {
                    mNetSenderResponse.setException(new Exception(conn.getResponseMessage()));
                    if (Mint.mintCallback != null) {
                        Mint.mintCallback.netSenderResponse(mNetSenderResponse);
                    }
                } else {
                    String line;
                    StringBuilder sb = new StringBuilder();
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                    mNetSenderResponse.setServerResponse(sb.toString());
                    mNetSenderResponse.setSentSuccessfully(true);
                }
            }
            catch (Exception e) {
                Logger.logError("NetSender: Transmitting Exception " + e.getMessage());
                if (Mint.DEBUG) {
                    e.printStackTrace();
                }
                mNetSenderResponse.setResponseCode(0);
                mNetSenderResponse.setException(e);
                if (Mint.mintCallback != null) {
                    Mint.mintCallback.netSenderResponse(mNetSenderResponse);
                }
                if (saveOnFail) {
                    Logger.logWarning("NetSender: Couldn't send data, saving...");
                    DataSaver.save(data);
                }
                NetSenderResponse netSenderResponse = mNetSenderResponse;
                return netSenderResponse;
            }
            finally {
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                }
                if (gos != null) {
                    try {
                        gos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (Mint.mintCallback != null) {
                Mint.mintCallback.netSenderResponse(mNetSenderResponse);
            }
            return mNetSenderResponse;
        }
        NetSenderResponse mNetSenderResponse = new NetSenderResponse(url, null);
        mNetSenderResponse.setSentSuccessfully(false);
        mNetSenderResponse.setException(new Exception("User has opt out from logging data!"));
        return mNetSenderResponse;
    }

    private static int findAllActions(String data) {
        Pattern p = Pattern.compile("\\{\\^[0-9]+?\\^[a-z]+?\\^[0-9]+?\\}");
        Matcher m = p.matcher(data);
        int count = 0;
        while (m.find()) {
            ++count;
        }
        return count;
    }

    private static int findAllErrors(String data) {
        Pattern p = Pattern.compile("\\^" + EnumActionType.getStringFromType((byte)0) + "\\^");
        Matcher m = p.matcher(data);
        int count = 0;
        while (m.find()) {
            ++count;
        }
        return count;
    }
}

