package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.view.View;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.model.LogMessageItem;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TextDecorator;

public class LogMessageHolder extends RecyclerView.ViewHolder {

  private Context context;
  private View root;
  private TextView textLog;

  private int datetimeSize;

  public LogMessageHolder(View itemView) {
    super(itemView);

    context = itemView.getContext();
    root = itemView;
    textLog = (TextView) itemView.findViewById(R.id.text_log);
    datetimeSize = (int) context.getResources().getDimension(R.dimen.ch_log_message_date_text_size);
  }

  public void bind(LogMessageItem item) {
    if (item != null && item.isLogResolve()) {
      String messageTime = item.getCreatedTime();
      SpannableString result = new SpannableString(String.format(
        "%s  %s",
        ResUtils.getString(context, "ch.log.resolved"),
        messageTime));
      result = TextDecorator.color(result, messageTime, ContextCompat.getColor(context, R.color.ch_light));
      result = TextDecorator.size(result, messageTime, datetimeSize);

      textLog.setText(result);
      root.setVisibility(View.VISIBLE);
    } else {
      root.setVisibility(View.GONE);
    }
  }
}
