package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Patterns;
import com.zoyi.channel.plugin.android.view.handler.TextLinkClickListener;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;


public class LinkedTextView extends TextView {

  private List<Hyperlink> listOfLinks;
  private TextLinkClickListener listener;

  private int linkTextColor;

  public LinkedTextView(Context context) {
    super(context);
    init();
  }

  public LinkedTextView(Context context, AttributeSet attrs) {
    super(context, attrs);
    init();
  }

  private void init() {
    listOfLinks = new ArrayList<>();
    linkTextColor = ContextCompat.getColor(getContext(), R.color.ch_cobalt);
    setMovementMethod(LinkMovementMethod.getInstance());
  }

  public void setLinkColor(int linkTextColor) {
    this.linkTextColor = linkTextColor;
  }

  public void setLinkedText(String text) {
    listOfLinks.clear();
    SpannableString linkableText = new SpannableString(text);
    gatherLinks(listOfLinks, linkableText);

    for (Hyperlink listOfLink : listOfLinks) {
      try {
        linkableText.setSpan(
            listOfLink.span,
            listOfLink.start,
            listOfLink.end,
            Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
      } catch (Exception ex) {
      }
    }

    setText(linkableText);
  }

  public void setOnTextLinkClickListener(TextLinkClickListener listener) {
    this.listener = listener;
  }

  private void gatherLinks(List<Hyperlink> links, Spannable s) {
    Matcher m = Patterns.WEB_URL.matcher(s);

    while (m.find()) {
      int start = m.start();
      int end = m.end();

      Hyperlink spec = new Hyperlink();
      spec.span = new InternalURLSpan(s.subSequence(start, end).toString());
      spec.start = start;
      spec.end = end;

      links.add(spec);
    }
  }

  private class InternalURLSpan extends ClickableSpan {
    private String string;

    InternalURLSpan(String string) {
      this.string = string;
    }

    @Override
    public void onClick(View textView) {
      if (listener != null && string != null) {
        listener.onTextLinkClick(textView, string.trim());
      }
    }

    @Override
    public void updateDrawState(@NonNull TextPaint textPaint) {
      try {
        textPaint.setColor(linkTextColor);
        textPaint.setUnderlineText(false);
      } catch (Exception ignored) { }
    }
  }

  private class Hyperlink {
    InternalURLSpan span;
    int start;
    int end;
  }
}