/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.model.wrapper.CountryWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.DeviceTokenBox;
import com.zoyi.channel.plugin.android.model.wrapper.GuestWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessagesWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ScriptsWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserVeilWrapper;
import com.zoyi.okhttp3.MultipartBody;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.retrofit2.http.Body;
import com.zoyi.retrofit2.http.DELETE;
import com.zoyi.retrofit2.http.GET;
import com.zoyi.retrofit2.http.Header;
import com.zoyi.retrofit2.http.HeaderMap;
import com.zoyi.retrofit2.http.Headers;
import com.zoyi.retrofit2.http.Multipart;
import com.zoyi.retrofit2.http.POST;
import com.zoyi.retrofit2.http.PUT;
import com.zoyi.retrofit2.http.Part;
import com.zoyi.retrofit2.http.Path;
import com.zoyi.retrofit2.http.Query;
import com.zoyi.rx.Observable;
import java.util.Map;

public interface ChannelApi {
    @GET(value="packages/{packageId}/versions/latest")
    public Observable<PackageWrapper> getLastestPackage(@Path(value="packageId") String var1, @Query(value="from") String var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/app/plugins/{key}/check_in")
    public Observable<PluginWrapper> checkIn(@HeaderMap Map<String, String> var1, @Path(value="key") String var2, @Query(value="url") String var3, @Body RequestBody var4);

    @GET(value="/app/plugins/{key}")
    public Observable<PluginWrapper> getPlugin(@Path(value="key") String var1);

    @GET(value="/app/scripts")
    public Observable<ScriptsWrapper> getScripts();

    @GET(value="/app/guests/me")
    public Observable<GuestWrapper> getMe();

    @GET(value="/app/user_chats")
    public Observable<UserChatsWrapper> getUserChats(@Query(value="sortField") String var1, @Query(value="sortOrder") String var2, @Query(value="limit") Integer var3, String ... var4);

    @GET(value="/app/user_chats/{userChatId}")
    public Observable<UserChatWrapper> getUserChat(@Path(value="userChatId") String var1);

    @GET(value="/app/user_chats/{userChatId}/messages")
    public Observable<MessagesWrapper> getMessages(@Path(value="userChatId") String var1, @Query(value="since") String var2, @Query(value="limit") Integer var3, @Query(value="sortOrder") String var4);

    @POST(value="/app/user_chats")
    public Observable<UserChatWrapper> createUserChat(@Header(value="X-Plugin-Key") String var1);

    @PUT(value="/app/user_chats/{userChatId}/messages/read_all")
    public Observable<Void> readAll(@Path(value="userChatId") String var1);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/app/user_chats/{userChatId}/messages")
    public Observable<MessageWrapper> sendMessage(@Path(value="userChatId") String var1, @Body RequestBody var2);

    @Multipart
    @POST(value="/app/user_chats/{userChatId}/messages/file")
    public Observable<MessageWrapper> uploadFile(@Path(value="userChatId") String var1, @Part MultipartBody.Part var2, @Part(value="requestId") RequestBody var3);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="/app/guests")
    public Observable<UserVeilWrapper> updateGuest(@Body RequestBody var1);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="app/device_tokens")
    public Observable<DeviceTokenBox> sendToken(@Body RequestBody var1);

    @Headers(value={"Content-Type: application/json"})
    @DELETE(value="app/device_tokens/{platform}/{key}")
    public Observable<Void> deleteToken(@Header(value="X-Channel-Id") String var1, @Path(value="platform") String var2, @Path(value="key") String var3);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="app/user_chats/{userChatId}/remove")
    public Observable<Void> removeUserChat(@Path(value="userChatId") String var1);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="app/user_chats/{userChatId}/done")
    public Observable<UserChatWrapper> reviewUserChat(@Path(value="userChatId") String var1, @Query(value="review") String var2);

    @GET(value="/countries")
    public Observable<CountryWrapper> getCountries();

    @POST(value="/app/events")
    public Observable<Void> trackEvent(@Body Event var1);
}

