package com.zoyi.channel.plugin.android.activity.chat;

import com.zoyi.channel.plugin.android.activity.base.BaseDictionary;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by mika on 2016. 12. 8..
 */
public class ChatDataDictionary extends BaseDictionary {
  private Map<String, Manager> managerMap;
  private Map<String, Bot> botMap;


  public ChatDataDictionary() {
    managerMap = new HashMap<>();
    botMap = new HashMap<>();
  }

  @Override
  public <E extends ChannelModel> E get(Class<E> clazz, String id) {
    if (id != null) {
      String className = clazz.getSimpleName();
      switch (className) {
        case Manager.CLASSNAME:
          return (E) managerMap.get(id);
        case Bot.CLASSNAME:
          return (E) botMap.get(id);
      }
    }
    return null;
  }

  @Override
  public void add(List<? extends ChannelModel> channelModels) {
    if (channelModels != null) {
      for (ChannelModel channelModel : channelModels) {
        if (checkCanUpdate(channelModel)) {
          String className = channelModel.getClass().getSimpleName();
          switch (className) {
            case Manager.CLASSNAME:
              managerMap.put(channelModel.getId(), (Manager) channelModel);
              break;

            case Bot.CLASSNAME:
              botMap.put(channelModel.getId(), (Bot) channelModel);
              break;
          }
        }
      }
    }
  }

  @Override
  protected void remove(ChannelModel channelModel) {
    // do nothing...
  }

  public ProfileEntity getProfile(String personType, String personId) {
    if (personType == null || personId == null) {
      return null;
    }
    switch (personType) {
      case Manager.CLASSNAME:
        return managerMap.get(personId);
      case Bot.CLASSNAME:
        return botMap.get(personId);
      default:
        return null;
    }
  }
}
