package com.zoyi.channel.plugin.android.presenter.chat;

import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.UserInfoItem;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.presenter.BasePresenter;
import com.zoyi.channel.plugin.android.presenter.BaseView;

import java.util.ArrayList;

public interface ChatContract {

  interface View extends BaseView<Presenter> {

    void onLoadUserChat();
    void setInputLayoutVisibility();
    void scrollToBottom(boolean force);
    void scrollTo(int index);
    void setRefreshVisibility(boolean showRefresh);
    void setToastVisibility(boolean showToast);
    void showBottomPreview(Manager manager, Message message);
    void onRemovedChat();
    void onFileDownload(Message message);
    void onShowPhotoAlbum(File file);
    void onUrlClicked(String url);
    void sendingMessageClicked(SendingMessageItem item);
    void setReconnectVisibility(boolean show);
  }

  interface Presenter extends BasePresenter<View> {

    String getChatId();
    boolean isStateCompleted();
    int getBackColor();
    int getTextColor();
    void setChatId(String chatId);
    void setColor(int backColor, int textColor);
    void setAdapterView(ChatAdapterContract.View adapterView);
    void setAdapterModel(ChatAdapterContract.Model adapterModel);
    void init();
    void fetchUserChat();
    void fetchMessages();
    void fetchInitMessages(final int count);
    void fetchForwardMessages(String since, final int count);
    void fetchBackwardMessages();
    void calculateNewToast(int index);
    void newToastClicked();
    void hideNewToast();
    void sendTextMessage(String message);
    void sendImageFiles(ArrayList<String> imagePaths);
    void receiveData(ChannelModel channelModel, boolean upsert);
    void receiveCommand(Command command, Object object);
    UserInfoItem getUserInfoItem();
    ProfileEntity getProfile(String personType, String personId);
    void resend(SendingMessageItem item);
    void removeFailedItem(SendingMessageItem item);
    void refresh();
    void leaveChat();
  }

}
