package com.zoyi.channel.plugin.android.push;

import android.os.Bundle;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.global.Const;

class PushData {

  private static final String CHANNEL_IO = "Channel.io";

  private String message;
  private String sound;
  private String channelId;
  private String chatType;
  private String chatId;
  private String url;
  private String provider;

  PushData(Bundle bundle) {
    message = bundle.getString(Const.EXTRA_MESSAGE);
    sound = bundle.getString(Const.EXTRA_SOUND);
    channelId = bundle.getString(Const.EXTRA_CHANNEL_ID);
    chatType = bundle.getString(Const.EXTRA_CHAT_TYPE);
    chatId = bundle.getString(Const.EXTRA_CHAT_ID);
    url = bundle.getString(Const.EXTRA_URL);
    provider = bundle.getString(Const.EXTRA_PROVIDER);
  }

  public String getMessage() {
    return message;
  }

  public String getSound() {
    return sound;
  }

  public String getChannelId() {
    return channelId;
  }

  public String getChatType() {
    return chatType;
  }

  public String getChatId() {
    return chatId;
  }

  public String getUrl() {
    return url;
  }

  public String getProvider() {
    return provider;
  }

  public boolean isChannelPluginMessage() {
    return !TextUtils.isEmpty(provider) && provider.equals(CHANNEL_IO);
  }
}
