/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.push;

import android.annotation.SuppressLint;
import android.app.NotificationManager;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.global.CheckInPrefSupervisor;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.push.NotificationFactory;
import com.zoyi.channel.plugin.android.push.PushData;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.Map;

public class ChannelPushManager {
    private static final int NOTIFICATION_ID = 95991298;

    private static Bundle convertMessageMapToBundle(Map<String, String> message) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : message.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }

    public static boolean isChannelPluginMessage(Map<String, String> message) {
        return ChannelPushManager.isChannelPluginMessage(ChannelPushManager.convertMessageMapToBundle(message));
    }

    public static boolean isChannelPluginMessage(Bundle message) {
        if (message == null) {
            return false;
        }
        PushData pushData = new PushData(message);
        return pushData.isChannelPluginMessage();
    }

    @SuppressLint(value={"HardwareIds"})
    public static void sendTokenToChannelPlugin(Context context) {
        String token = PrefSupervisor.getDeviceToken(context);
        if (!TextUtils.isEmpty((CharSequence)token)) {
            RequestBody body = RequestUtils.form().set("platform", "android").set("key", Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id")).set("token", token).create();
            ChannelPlugin.getApi().sendToken(body).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new RestSubscriber());
        }
    }

    public static void deleteToken(Context context) {
    }

    public static void handlePush(Context context, Map<String, String> message) {
        ChannelPushManager.handlePush(context, ChannelPushManager.convertMessageMapToBundle(message));
    }

    public static void handlePush(Context context, Bundle message) {
        if (CheckInPrefSupervisor.hasCheckInData(context)) {
            ChannelPushManager.sendNotification(context, message);
        }
    }

    private static void sendNotification(Context context, Bundle message) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.notify(95991298, NotificationFactory.createPushMessage(context, new PushData(message)));
    }

    static void clearNotification(Context context) {
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.cancel(95991298);
        }
        catch (Exception ex) {
            L.e(ex.getMessage());
        }
    }
}

