package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.SortedListCallback;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatItem;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatAdapterContract;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by mika on 2016. 12. 6..
 */
class UserChatListAdapter extends RecyclerView.Adapter<UserChatHolder>
    implements UserChatAdapterContract.View, UserChatAdapterContract.Model {

  private OnUserChatClickListener listener;

  private Map<String, UserChatItem> map;
  private UserChatListDataDictionary dictionary;
  private SortedList<UserChatItem> items;
  private boolean refreshBySocket = false;

  UserChatListAdapter() {
    map = new HashMap<>();
    dictionary = new UserChatListDataDictionary();
    items = new SortedList<>(UserChatItem.class, new SortedListCallback(this, true));
  }

  @Override
  public void setOnUserChatClickListener(OnUserChatClickListener listener) {
    this.listener = listener;
  }

  @Override
  public void init(UserChatsWrapper wrapper) {
    dictionary.add(wrapper.getManagers());
    dictionary.add(wrapper.getSessions());
    dictionary.add(wrapper.getMessages());

    List<UserChatItem> delta = new ArrayList<>();
    for (UserChat userChat : wrapper.getUserChats()) {
      UserChatItem item = new UserChatItem(userChat, dictionary);
      if (map.containsKey(userChat.getId())) {
        items.remove(map.get(userChat.getId()));
      }
      delta.add(item);
    }

    for (UserChatItem item : delta) {
      map.put(item.getId(), item);
    }
    items.clear();
    items.addAll(delta);

    refreshBySocket = true;
  }

  @Override
  public void stopRefreshBySocket() {
    this.refreshBySocket = false;
  }

  @Override
  public UserChatHolder onCreateViewHolder(ViewGroup parent, int viewType) {
    Context c = parent.getContext();
    View view = LayoutInflater.from(c).inflate(R.layout.ch_plugin_item_user_chat, parent, false);

    return new UserChatHolder(view, listener);
  }

  @Override
  public void onBindViewHolder(UserChatHolder holder, int position) {
    holder.setUserChatItem(items.get(position));
  }

  @Override
  public int getItemCount() {
    return items.size();
  }

  @Override
  public void receiveChannelModel(ChannelModel channelModel, boolean upsert) {
    if (!refreshBySocket) {
      return;
    }
    if (upsert) {
      dictionary.add(channelModel);
    } else {
      dictionary.remove(channelModel);
    }

    switch (channelModel.getClass().getSimpleName()) {
      case UserChat.CLASSNAME:
        updateUserChat((UserChat) channelModel, upsert);
        break;

      case Session.CLASSNAME:
        updateSession((Session) channelModel);
        break;

      case Manager.CLASSNAME:
        updateManager(channelModel.getId());
        break;

      case ReferMessage.CLASSNAME:
        // do nothing
        break;
    }
  }

  private void updateUserChat(UserChat userChat, boolean upsert) {
    for (int i = 0; i < items.size(); i++) {
      UserChatItem item = items.get(i);

      if (item.getId().equals(userChat.getId())) {
        if (upsert) {
          item.setUserChat(userChat);
          items.updateItemAt(i, item);
        } else {
          items.removeItemAt(i);
        }
        return;
      }
    }
    items.add(new UserChatItem(userChat, dictionary));
  }

  private void updateManager(String managerId) {
    for (int i = 0; i < items.size(); i++) {
      UserChatItem item = items.get(i);

      if (item.containsManager(managerId)) {
        items.updateItemAt(i, item);
      }
    }
  }

  private void updateSession(Session session) {
    for (int i = 0; i < items.size(); i++) {
      UserChatItem item = items.get(i);

      if (item.getSessionId().equals(session.getId())) {
        item.setSession(session);
        items.updateItemAt(i, item);
        break;
      }
    }
  }
}
