/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ChatMessageHolder;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

public class ManagerMessageHolder
extends ChatMessageHolder {
    Context context;
    AvatarLayout avatar;
    TextView textName;
    LinearLayout contentList;

    public ManagerMessageHolder(View itemView, OnMessageClickListener listener) {
        super(itemView, listener);
        this.context = itemView.getContext();
        this.avatar = (AvatarLayout)itemView.findViewById(R.id.message_avatar);
        this.textName = (TextView)itemView.findViewById(R.id.message_name);
        this.contentList = (LinearLayout)itemView.findViewById(R.id.message_addon_content);
    }

    protected void setProfile(ProfileEntity profile) {
        this.avatar.set(profile);
        if (profile == null) {
            this.textName.setText((CharSequence)ResUtils.getString(this.context, "ch.unknown"));
        } else {
            this.textName.setText((CharSequence)profile.getName());
        }
    }

    public void set(ChatMessageItem item, ProfileEntity profile, boolean isContext) {
        super.set(item.getMessage(), isContext);
        this.contentList.setVisibility(8);
        this.setProfile(profile);
    }
}

