/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.plugins.RxJavaHooks;

public final class OnSubscribeLift<T, R>
implements Observable.OnSubscribe<R> {
    final Observable.OnSubscribe<T> parent;
    final Observable.Operator<? extends R, ? super T> operator;

    public OnSubscribeLift(Observable.OnSubscribe<T> parent, Observable.Operator<? extends R, ? super T> operator) {
        this.parent = parent;
        this.operator = operator;
    }

    @Override
    public void call(Subscriber<? super R> o) {
        try {
            Subscriber st = (Subscriber)RxJavaHooks.onObservableLift(this.operator).call(o);
            try {
                st.onStart();
                this.parent.call(st);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                st.onError(e);
            }
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            o.onError(e);
        }
    }
}

