package com.zoyi.channel.plugin.android.model.source.photopicker;

import android.content.Context;
import android.database.Cursor;
import android.provider.MediaStore;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Func0;
import com.zoyi.rx.schedulers.Schedulers;

import java.io.File;
import java.util.ArrayList;

public class PhotoDataSource {

  public void getPhotoItems(final Context context, Subscriber<ArrayList<PhotoItem>> subscriber) {
    Observable.defer(
        new Func0<Observable<ArrayList<PhotoItem>>>() {
          @Override
          public Observable<ArrayList<PhotoItem>> call() {
            return Observable.just(getPhotoItems(context));
          }
        })
        .subscribeOn(Schedulers.newThread())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(subscriber);
  }

  private ArrayList<PhotoItem> getPhotoItems(Context context) {
    ArrayList<PhotoItem> photoItems = new ArrayList<>();
    String[] projection = new String[] {
        MediaStore.Images.Media._ID,
        MediaStore.Images.Media.DISPLAY_NAME,
        MediaStore.Images.Media.DATA,
        MediaStore.Images.Media.BUCKET_DISPLAY_NAME
    };
    Cursor cursor = context.getContentResolver().query(
        MediaStore.Images.Media.EXTERNAL_CONTENT_URI,
        projection,
        null,
        null,
        MediaStore.Images.Media.DATE_ADDED);

    if (cursor == null) {
      return photoItems;
    }

    int index = 0;

    if (cursor.moveToLast()) {
      do {
        long id = cursor.getLong(cursor.getColumnIndex(projection[0]));
        String name = cursor.getString(cursor.getColumnIndex(projection[1]));
        String path = cursor.getString(cursor.getColumnIndex(projection[2]));
        File file = new File(path);

        if (file.exists()) {
          photoItems.add(new PhotoItem(id, name, path, index++));
        }
      } while (cursor.moveToPrevious());
    }
    cursor.close();

    return photoItems;
  }
}
