/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.fab;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Outline;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.ImageButton;
import android.widget.ScrollView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.external.fab.AbsListViewScrollDetector;
import com.zoyi.channel.plugin.android.view.external.fab.ObservableScrollView;
import com.zoyi.channel.plugin.android.view.external.fab.RecyclerViewScrollDetector;
import com.zoyi.channel.plugin.android.view.external.fab.ScrollDirectionListener;
import com.zoyi.channel.plugin.android.view.external.fab.ScrollViewScrollDetector;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.view.ViewHelper;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.view.ViewPropertyAnimator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class FloatingActionButton
extends ImageButton {
    private static final int TRANSLATE_DURATION_MILLIS = 200;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_MINI = 1;
    private boolean mVisible;
    private int mColorNormal;
    private int mColorPressed;
    private int mColorRipple;
    private int mColorDisabled;
    private boolean mShadow;
    private int mType;
    private int mShadowSize;
    private int mScrollThreshold;
    private boolean mMarginsSet;
    private final Interpolator mInterpolator = new AccelerateDecelerateInterpolator();

    public FloatingActionButton(Context context) {
        this(context, null);
    }

    public FloatingActionButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public FloatingActionButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int size = this.getDimension(this.mType == 0 ? R.dimen.ch_fab_size_normal : R.dimen.ch_fab_size_mini);
        if (this.mShadow && !this.hasLollipopApi()) {
            size += this.mShadowSize * 2;
            this.setMarginsWithoutShadow();
        }
        this.setMeasuredDimension(size, size);
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.mVisible = true;
        this.mColorNormal = this.getColor(R.color.ch_material_blue_500);
        this.mColorPressed = FloatingActionButton.darkenColor(this.mColorNormal);
        this.mColorRipple = FloatingActionButton.lightenColor(this.mColorNormal);
        this.mColorDisabled = this.getColor(0x1060000);
        this.mType = 0;
        this.mShadow = true;
        this.mScrollThreshold = this.getResources().getDimensionPixelOffset(R.dimen.ch_fab_scroll_threshold);
        this.mShadowSize = this.getDimension(R.dimen.ch_fab_shadow_size);
        if (attributeSet != null) {
            this.initAttributes(context, attributeSet);
        }
        this.updateBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes(Context context, AttributeSet attributeSet) {
        TypedArray attr2 = this.getTypedArray(context, attributeSet, R.styleable.FloatingActionButton);
        if (attr2 != null) {
            try {
                this.mColorNormal = attr2.getColor(R.styleable.FloatingActionButton_ch_fab_colorNormal, this.getColor(R.color.ch_material_blue_500));
                this.mColorPressed = attr2.getColor(R.styleable.FloatingActionButton_ch_fab_colorPressed, FloatingActionButton.darkenColor(this.mColorNormal));
                this.mColorRipple = attr2.getColor(R.styleable.FloatingActionButton_ch_fab_colorRipple, FloatingActionButton.lightenColor(this.mColorNormal));
                this.mColorDisabled = attr2.getColor(R.styleable.FloatingActionButton_ch_fab_colorDisabled, this.mColorDisabled);
                this.mShadow = attr2.getBoolean(R.styleable.FloatingActionButton_ch_fab_shadow, true);
                this.mType = attr2.getInt(R.styleable.FloatingActionButton_ch_fab_type, 0);
            }
            finally {
                attr2.recycle();
            }
        }
    }

    private void updateBackground() {
        StateListDrawable drawable2 = new StateListDrawable();
        drawable2.addState(new int[]{16842919}, this.createDrawable(this.mColorPressed));
        drawable2.addState(new int[]{-16842910}, this.createDrawable(this.mColorDisabled));
        drawable2.addState(new int[0], this.createDrawable(this.mColorNormal));
        this.setBackgroundCompat((Drawable)drawable2);
    }

    private Drawable createDrawable(int color2) {
        OvalShape ovalShape = new OvalShape();
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)ovalShape);
        shapeDrawable.getPaint().setColor(color2);
        if (this.mShadow && !this.hasLollipopApi()) {
            Drawable shadowDrawable = this.getResources().getDrawable(this.mType == 0 ? R.drawable.ch_plugin_fab_shadow : R.drawable.ch_plugin_fab_shadow_mini);
            LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{shadowDrawable, shapeDrawable});
            layerDrawable.setLayerInset(1, this.mShadowSize, this.mShadowSize, this.mShadowSize, this.mShadowSize);
            return layerDrawable;
        }
        return shapeDrawable;
    }

    private TypedArray getTypedArray(Context context, AttributeSet attributeSet, int[] attr2) {
        return context.obtainStyledAttributes(attributeSet, attr2, 0, 0);
    }

    private int getColor(@ColorRes int id2) {
        return this.getResources().getColor(id2);
    }

    private int getDimension(@DimenRes int id2) {
        return this.getResources().getDimensionPixelSize(id2);
    }

    private void setMarginsWithoutShadow() {
        if (!this.mMarginsSet && this.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
            int leftMargin = layoutParams.leftMargin - this.mShadowSize;
            int topMargin = layoutParams.topMargin - this.mShadowSize;
            int rightMargin = layoutParams.rightMargin - this.mShadowSize;
            int bottomMargin = layoutParams.bottomMargin - this.mShadowSize;
            layoutParams.setMargins(leftMargin, topMargin, rightMargin, bottomMargin);
            this.requestLayout();
            this.mMarginsSet = true;
        }
    }

    @SuppressLint(value={"NewApi"})
    private void setBackgroundCompat(Drawable drawable2) {
        if (this.hasLollipopApi()) {
            float elevation = this.mShadow ? (this.getElevation() > 0.0f ? this.getElevation() : (float)this.getDimension(R.dimen.ch_fab_elevation_lollipop)) : 0.0f;
            this.setElevation(elevation);
            RippleDrawable rippleDrawable = new RippleDrawable(new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{this.mColorRipple}), drawable2, null);
            this.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    int size = FloatingActionButton.this.getDimension(FloatingActionButton.this.mType == 0 ? R.dimen.ch_fab_size_normal : R.dimen.ch_fab_size_mini);
                    outline.setOval(0, 0, size, size);
                }
            });
            this.setClipToOutline(true);
            this.setBackground((Drawable)rippleDrawable);
        } else if (this.hasJellyBeanApi()) {
            this.setBackground(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    private int getMarginBottom() {
        int marginBottom = 0;
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            marginBottom = ((ViewGroup.MarginLayoutParams)layoutParams).bottomMargin;
        }
        return marginBottom;
    }

    public void setColorNormal(int color2) {
        if (color2 != this.mColorNormal) {
            this.mColorNormal = color2;
            this.updateBackground();
        }
    }

    public void setColorNormalResId(@ColorRes int colorResId) {
        this.setColorNormal(this.getColor(colorResId));
    }

    public int getColorNormal() {
        return this.mColorNormal;
    }

    public void setColorPressed(int color2) {
        if (color2 != this.mColorPressed) {
            this.mColorPressed = color2;
            this.updateBackground();
        }
    }

    public void setColorPressedResId(@ColorRes int colorResId) {
        this.setColorPressed(this.getColor(colorResId));
    }

    public int getColorPressed() {
        return this.mColorPressed;
    }

    public void setColorRipple(int color2) {
        if (color2 != this.mColorRipple) {
            this.mColorRipple = color2;
            this.updateBackground();
        }
    }

    public void setColorRippleResId(@ColorRes int colorResId) {
        this.setColorRipple(this.getColor(colorResId));
    }

    public int getColorRipple() {
        return this.mColorRipple;
    }

    public void setShadow(boolean shadow) {
        if (shadow != this.mShadow) {
            this.mShadow = shadow;
            this.updateBackground();
        }
    }

    public boolean hasShadow() {
        return this.mShadow;
    }

    public void setType(int type) {
        if (type != this.mType) {
            this.mType = type;
            this.updateBackground();
        }
    }

    public int getType() {
        return this.mType;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public void show() {
        this.show(true);
    }

    public void hide() {
        this.hide(true);
    }

    public void show(boolean animate) {
        this.toggle(true, animate, false);
    }

    public void hide(boolean animate) {
        this.toggle(false, animate, false);
    }

    private void toggle(final boolean visible, final boolean animate, boolean force) {
        if (this.mVisible != visible || force) {
            int translationY;
            ViewTreeObserver vto;
            this.mVisible = visible;
            int height = this.getHeight();
            if (height == 0 && !force && (vto = this.getViewTreeObserver()).isAlive()) {
                vto.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                    public boolean onPreDraw() {
                        ViewTreeObserver currentVto = FloatingActionButton.this.getViewTreeObserver();
                        if (currentVto.isAlive()) {
                            currentVto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        }
                        FloatingActionButton.this.toggle(visible, animate, true);
                        return true;
                    }
                });
                return;
            }
            int n = translationY = visible ? 0 : height + this.getMarginBottom();
            if (animate) {
                ViewPropertyAnimator.animate((View)this).setInterpolator(this.mInterpolator).setDuration(200L).translationY(translationY);
            } else {
                ViewHelper.setTranslationY((View)this, translationY);
            }
            if (!this.hasHoneycombApi()) {
                this.setClickable(visible);
            }
        }
    }

    public void attachToListView(@NonNull AbsListView listView) {
        this.attachToListView(listView, null, null);
    }

    public void attachToListView(@NonNull AbsListView listView, ScrollDirectionListener scrollDirectionListener) {
        this.attachToListView(listView, scrollDirectionListener, null);
    }

    public void attachToRecyclerView(@NonNull RecyclerView recyclerView) {
        this.attachToRecyclerView(recyclerView, null, null);
    }

    public void attachToRecyclerView(@NonNull RecyclerView recyclerView, ScrollDirectionListener scrollDirectionListener) {
        this.attachToRecyclerView(recyclerView, scrollDirectionListener, null);
    }

    public void attachToScrollView(@NonNull ObservableScrollView scrollView) {
        this.attachToScrollView(scrollView, null, null);
    }

    public void attachToScrollView(@NonNull ObservableScrollView scrollView, ScrollDirectionListener scrollDirectionListener) {
        this.attachToScrollView(scrollView, scrollDirectionListener, null);
    }

    public void attachToListView(@NonNull AbsListView listView, ScrollDirectionListener scrollDirectionListener, AbsListView.OnScrollListener onScrollListener) {
        AbsListViewScrollDetectorImpl scrollDetector = new AbsListViewScrollDetectorImpl();
        scrollDetector.setScrollDirectionListener(scrollDirectionListener);
        scrollDetector.setOnScrollListener(onScrollListener);
        scrollDetector.setListView(listView);
        scrollDetector.setScrollThreshold(this.mScrollThreshold);
        listView.setOnScrollListener((AbsListView.OnScrollListener)scrollDetector);
    }

    public void attachToRecyclerView(@NonNull RecyclerView recyclerView, ScrollDirectionListener scrollDirectionlistener, RecyclerView.OnScrollListener onScrollListener) {
        RecyclerViewScrollDetectorImpl scrollDetector = new RecyclerViewScrollDetectorImpl();
        scrollDetector.setScrollDirectionListener(scrollDirectionlistener);
        scrollDetector.setOnScrollListener(onScrollListener);
        scrollDetector.setScrollThreshold(this.mScrollThreshold);
        recyclerView.setOnScrollListener((RecyclerView.OnScrollListener)scrollDetector);
    }

    public void attachToScrollView(@NonNull ObservableScrollView scrollView, ScrollDirectionListener scrollDirectionListener, ObservableScrollView.OnScrollChangedListener onScrollChangedListener) {
        ScrollViewScrollDetectorImpl scrollDetector = new ScrollViewScrollDetectorImpl();
        scrollDetector.setScrollDirectionListener(scrollDirectionListener);
        scrollDetector.setOnScrollChangedListener(onScrollChangedListener);
        scrollDetector.setScrollThreshold(this.mScrollThreshold);
        scrollView.setOnScrollChangedListener(scrollDetector);
    }

    private boolean hasLollipopApi() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private boolean hasJellyBeanApi() {
        return Build.VERSION.SDK_INT >= 16;
    }

    private boolean hasHoneycombApi() {
        return Build.VERSION.SDK_INT >= 11;
    }

    private static int darkenColor(int color2) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color2, (float[])hsv);
        hsv[2] = hsv[2] * 0.9f;
        return Color.HSVToColor((float[])hsv);
    }

    private static int lightenColor(int color2) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color2, (float[])hsv);
        hsv[2] = hsv[2] * 1.1f;
        return Color.HSVToColor((float[])hsv);
    }

    private class ScrollViewScrollDetectorImpl
    extends ScrollViewScrollDetector {
        private ScrollDirectionListener mScrollDirectionListener;
        private ObservableScrollView.OnScrollChangedListener mOnScrollChangedListener;

        private ScrollViewScrollDetectorImpl() {
        }

        private void setScrollDirectionListener(ScrollDirectionListener scrollDirectionListener) {
            this.mScrollDirectionListener = scrollDirectionListener;
        }

        public void setOnScrollChangedListener(ObservableScrollView.OnScrollChangedListener onScrollChangedListener) {
            this.mOnScrollChangedListener = onScrollChangedListener;
        }

        @Override
        public void onScrollDown() {
            FloatingActionButton.this.show();
            if (this.mScrollDirectionListener != null) {
                this.mScrollDirectionListener.onScrollDown();
            }
        }

        @Override
        public void onScrollUp() {
            FloatingActionButton.this.hide();
            if (this.mScrollDirectionListener != null) {
                this.mScrollDirectionListener.onScrollUp();
            }
        }

        @Override
        public void onScrollChanged(ScrollView who, int l, int t, int oldl, int oldt) {
            if (this.mOnScrollChangedListener != null) {
                this.mOnScrollChangedListener.onScrollChanged(who, l, t, oldl, oldt);
            }
            super.onScrollChanged(who, l, t, oldl, oldt);
        }
    }

    private class RecyclerViewScrollDetectorImpl
    extends RecyclerViewScrollDetector {
        private ScrollDirectionListener mScrollDirectionListener;
        private RecyclerView.OnScrollListener mOnScrollListener;

        private RecyclerViewScrollDetectorImpl() {
        }

        private void setScrollDirectionListener(ScrollDirectionListener scrollDirectionListener) {
            this.mScrollDirectionListener = scrollDirectionListener;
        }

        public void setOnScrollListener(RecyclerView.OnScrollListener onScrollListener) {
            this.mOnScrollListener = onScrollListener;
        }

        @Override
        public void onScrollDown() {
            FloatingActionButton.this.show();
            if (this.mScrollDirectionListener != null) {
                this.mScrollDirectionListener.onScrollDown();
            }
        }

        @Override
        public void onScrollUp() {
            FloatingActionButton.this.hide();
            if (this.mScrollDirectionListener != null) {
                this.mScrollDirectionListener.onScrollUp();
            }
        }

        @Override
        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            if (this.mOnScrollListener != null) {
                this.mOnScrollListener.onScrolled(recyclerView, dx, dy);
            }
            super.onScrolled(recyclerView, dx, dy);
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            if (this.mOnScrollListener != null) {
                this.mOnScrollListener.onScrollStateChanged(recyclerView, newState);
            }
            super.onScrollStateChanged(recyclerView, newState);
        }
    }

    private class AbsListViewScrollDetectorImpl
    extends AbsListViewScrollDetector {
        private ScrollDirectionListener mScrollDirectionListener;
        private AbsListView.OnScrollListener mOnScrollListener;

        private AbsListViewScrollDetectorImpl() {
        }

        private void setScrollDirectionListener(ScrollDirectionListener scrollDirectionListener) {
            this.mScrollDirectionListener = scrollDirectionListener;
        }

        public void setOnScrollListener(AbsListView.OnScrollListener onScrollListener) {
            this.mOnScrollListener = onScrollListener;
        }

        @Override
        public void onScrollDown() {
            FloatingActionButton.this.show();
            if (this.mScrollDirectionListener != null) {
                this.mScrollDirectionListener.onScrollDown();
            }
        }

        @Override
        public void onScrollUp() {
            FloatingActionButton.this.hide();
            if (this.mScrollDirectionListener != null) {
                this.mScrollDirectionListener.onScrollUp();
            }
        }

        @Override
        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (this.mOnScrollListener != null) {
                this.mOnScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
            super.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }

        @Override
        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (this.mOnScrollListener != null) {
                this.mOnScrollListener.onScrollStateChanged(view, scrollState);
            }
            super.onScrollStateChanged(view, scrollState);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TYPE {
    }
}

