/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_album;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoView;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher;
import com.zoyi.com.bumptech.glide.BitmapRequestBuilder;
import com.zoyi.com.bumptech.glide.Glide;

public class PhotoAlbumActivity
extends BaseActivity
implements PhotoViewAttacher.OnPhotoTapListener {
    PhotoView photoView;
    View layoutOverlay;
    View buttonClose;
    View buttonCopyLink;
    View buttonDownload;
    private String url;
    private String thumbnailUrl;
    private String filename;
    private Long size;
    private boolean menuVisible = true;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_photo_album);
        this.setStatusBarColor(-16777216);
        this.photoView = (PhotoView)this.findViewById(R.id.photo_view);
        this.layoutOverlay = this.findViewById(R.id.layout_image);
        this.buttonClose = this.findViewById(R.id.button_close_image);
        this.buttonCopyLink = this.findViewById(R.id.button_link);
        this.buttonDownload = this.findViewById(R.id.button_download);
        try {
            this.url = this.getIntent().getStringExtra("url");
            this.filename = this.getIntent().getStringExtra("filename");
            this.thumbnailUrl = this.getIntent().getStringExtra("thumbnailUrl");
            this.size = this.getIntent().getLongExtra("size", 0L);
        }
        finally {
            if (this.url == null || this.thumbnailUrl == null || this.filename == null || this.size == 0L) {
                UIUtils.showToast((Context)this, ResUtils.getString((Context)this, "ch.photo.read_file_info_failed"));
                this.finish();
            }
        }
        this.photoView.setOnPhotoTapListener(this);
        this.buttonClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhotoAlbumActivity.this.finish();
            }
        });
        this.buttonCopyLink.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhotoAlbumActivity.this.copyLink();
            }
        });
        this.buttonDownload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhotoAlbumActivity.this.download();
            }
        });
        ((BitmapRequestBuilder)((BitmapRequestBuilder)Glide.with((FragmentActivity)this).load(this.url).asBitmap().dontAnimate()).fitCenter()).into(this.photoView);
    }

    private void copyLink() {
        try {
            ClipboardManager clipboard = (ClipboardManager)this.getSystemService("clipboard");
            ClipData clip = ClipData.newPlainText((CharSequence)"text", (CharSequence)this.url);
            clipboard.setPrimaryClip(clip);
            UIUtils.showToast((Context)this, ResUtils.getString((Context)this, "ch.photo.url_copied_to_clipboard"));
        }
        catch (Exception ex) {
            UIUtils.showToast((Context)this, ResUtils.getString((Context)this, "ch.photo.read_file_info_failed"));
        }
    }

    private void download() {
        IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", this.url).putExtra("filename", this.filename).putExtra("image", true).startActivity();
    }

    @Override
    public void onPhotoTap(View view, float x, float y) {
        this.animateOverlay();
    }

    @Override
    public void onOutsidePhotoTap() {
        this.animateOverlay();
    }

    private void animateOverlay() {
        float from = this.menuVisible ? 1.0f : 0.0f;
        float to = this.menuVisible ? 0.0f : 1.0f;
        this.menuVisible = !this.menuVisible;
        this.buttonClose.setEnabled(this.menuVisible);
        this.buttonCopyLink.setEnabled(this.menuVisible);
        this.buttonDownload.setEnabled(this.menuVisible);
        this.buttonClose.setClickable(this.menuVisible);
        this.buttonCopyLink.setClickable(this.menuVisible);
        this.buttonDownload.setClickable(this.menuVisible);
        AlphaAnimation animation = new AlphaAnimation(from, to);
        animation.setDuration(200L);
        animation.setFillAfter(true);
        this.layoutOverlay.startAnimation((Animation)animation);
    }
}

