package com.zoyi.channel.plugin.android.activity.download;

import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.webkit.MimeTypeMap;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.DownloadUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.io.FilenameUtils;
import com.zoyi.channel.plugin.android.view.layout.DownloadProgressBar;
import com.zoyi.retrofit2.okhttp3.Call;

/**
 * Created by mika on 2017. 1. 11..
 */
public class DownloadActivity extends BaseActivity {
  private DownloadProgressBar progress;
  private View imageDone;
  private FrameLayout imageCancel;

  private String url, filename;
  private boolean image;
  private Call call;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.ch_plugin_activity_download);
    setStatusBarColor(Color.BLACK);

    progress = (DownloadProgressBar) findViewById(R.id.download_progress);
    imageDone = findViewById(R.id.image_done);
    imageCancel = (FrameLayout) findViewById(R.id.layout_cancel);

    imageCancel.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        L.i("Cancel download");
        try {
          if (call != null && !call.isCanceled()) {
            call.cancel();
          }
        } catch (Exception ignored) {
        }
      }
    });

    try {
      url = getIntent().getStringExtra("url");
      filename = getIntent().getStringExtra("filename");
      image = getIntent().getBooleanExtra("image", false);
    } finally {
      if (url == null || filename == null) {
        finish(Const.DOWNLOAD_FAILED);
      }
    }

    download();
  }

  @Override
  public void onBackPressed() { }

  @Override
  protected void onPause() {
    super.onPause();
    overridePendingTransition(0, 0);
  }

  private void finish(int resultCode) {
    setResult(resultCode);
    finish();
  }

  @Override
  protected void permissionAccepted(int requestCode) {
    if (requestCode == PERMISSION_WRITE_STORAGE) {
      download();
    } else {
      finish(Const.DOWNLOAD_FAILED);
    }
  }

  private void download() {
    if (checkPermission(PERMISSION_WRITE_STORAGE)) {
      imageCancel.setVisibility(View.VISIBLE);
      progress.setVisibility(View.VISIBLE);

      call = DownloadUtils.downloadFile(
          this,
          url,
          filename,
          image,
          new DownloadUtils.ProgressListener() {
            @Override
            public void update(int progress) {
              progressDownload(progress);
            }

            @Override
            public void error(Call call, String message) {
              L.e(message);

              if (call == null || !call.isCanceled()) {
                finish(Const.DOWNLOAD_FAILED);
              } else {
                finish(Const.DOWNLOAD_CANCEL);
              }
            }

            @Override
            public void done(String savePath) {
              finishDownload(savePath);
            }
          });

      if (call == null) {
        finish(Const.DOWNLOAD_FAILED);
      }
    }
  }

  private void progressDownload(int progress) {
    this.progress.setProgress(progress);
  }

  private void finishDownload(String savePath) {
    imageDone.setVisibility(View.VISIBLE);
    imageCancel.setVisibility(View.GONE);
    progress.setVisibility(View.GONE);

    L.i(savePath + " " + image);

    if (!image) {
      java.io.File file = new java.io.File(savePath);
      if (file.exists()) {
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        String ext = FilenameUtils.getExtension(savePath).toLowerCase();
        String type = mimeTypeMap.getMimeTypeFromExtension(ext);

        try {
          Intent intent = new Intent(Intent.ACTION_VIEW);
          intent.setDataAndType(Uri.fromFile(file), type);
          startActivity(intent);
        } catch (Exception ex) {
          L.e(ex.getMessage());
        }
      }
    }

    android.view.animation.Animation animation = AnimationUtils.loadAnimation(this, R.anim.ch_plugin_dialog_in);
    animation.setAnimationListener(new android.view.animation.Animation.AnimationListener() {
      @Override
      public void onAnimationStart(android.view.animation.Animation animation) { }

      @Override
      public void onAnimationEnd(android.view.animation.Animation animation) {
        finish(Const.DOWNLOAD_COMPLETE);
      }

      @Override
      public void onAnimationRepeat(android.view.animation.Animation animation) { }
    });
    imageDone.startAnimation(animation);
  }
}
