package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.ChatDataDictionary;
import com.zoyi.channel.plugin.android.activity.chat.listener.MessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ActionMessageItem;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;

/**
 * Created by mika on 2017. 2. 1..
 */
public class ActionMessageHolder extends ManagerMessageHolder {
  FrameLayout simpleAction;
  TextView simpleText;

  ActionMessageItem item;

  public ActionMessageHolder(
      final View itemView,
      final MessageClickListener listener,
      ChatDataDictionary dictionary) {
    super(itemView, listener, dictionary);

    simpleAction = (FrameLayout) itemView.findViewById(R.id.chat_action_simple);
    simpleText = (TextView) itemView.findViewById(R.id.chat_action_simple_text);

    simpleAction.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        if (listener != null) {
          listener.actionClicked(item);
        }
      }
    });
  }

  public void set(ActionMessageItem item) {
    super.set(item.getMessage(), false);
    setProfile(ChannelStore.getChannel());

    this.item = item;

    if (item.getActionType() == null) {
      contentList.setVisibility(View.GONE);
    } else {
      contentList.setVisibility(View.VISIBLE);
      for (int i = 0; i < contentList.getChildCount(); i++) {
        contentList.getChildAt(i).setVisibility(View.GONE);
      }

      switch (item.getActionType()) {
        case REQUEST_WORKING_TIME:
          simpleAction.setVisibility(View.VISIBLE);
          simpleText.setText(ResUtils.getString(itemView.getContext(), "ch.out_of_work.confirm"));
          break;
      }
    }
  }
}
