package com.zoyi.channel.plugin.android.activity.chat.model;

import com.zoyi.channel.plugin.android.activity.chat.type.ActionType;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.Message;

/**
 * Created by mika on 2017. 1. 26..
 */
public class ActionMessageItem implements MessageItem {
  private Long timestamp;
  private ActionType actionType;
  private Message message;

  public ActionMessageItem(Long timestamp, ActionType actionType, String message) {
    this.timestamp = timestamp;
    this.actionType = actionType;
    this.message = new Message(message);
  }

  @Override
  public Long getFirst() {
    return timestamp;
  }

  @Override
  public String getSecond() {
    return "ActionMessageItem";
  }

  @Override
  public MessageType getType() {
    return MessageType.ACTION_MESSAGE;
  }

  public ActionType getActionType() {
    return actionType;
  }

  public void setActionType(ActionType actionType) {
    this.actionType = actionType;
  }

  public Message getMessage() {
    return message;
  }

  public void setTimestamp(Long timestamp) {
    this.timestamp = timestamp;
  }

  public Long getTimestamp() {
    return timestamp;
  }
}
