/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.content.Context;
import android.database.Cursor;
import android.os.AsyncTask;
import android.provider.MediaStore;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoHolder;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoItem;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoItemEventListener;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoProcessListener;
import com.zoyi.channel.plugin.android.model.wrapper.MarginBox;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class PhotoPickerAdapter
extends RecyclerView.Adapter<PhotoHolder>
implements PhotoItemEventListener {
    private BaseActivity activity;
    private int layoutId;
    private boolean singleMode = false;
    private List<PhotoItem> photoItems;
    private List<PhotoItem> tempItems;
    private List<PhotoItem> selectedItems;
    private PhotoProcessListener listener;
    private int size = 1;
    private boolean loading = false;

    PhotoPickerAdapter(BaseActivity activity, int layoutId, PhotoProcessListener listener) {
        this.activity = activity;
        this.layoutId = layoutId;
        this.photoItems = new ArrayList<PhotoItem>();
        this.listener = listener;
        this.selectedItems = new ArrayList<PhotoItem>();
    }

    public PhotoHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new PhotoHolder(LayoutInflater.from((Context)parent.getContext()).inflate(this.layoutId, parent, false), this.singleMode, this.activity.getBackgroundColor(), this.activity.getTextColor(), viewType, this);
    }

    public void onBindViewHolder(PhotoHolder holder, int position) {
        MarginBox marginBox = this.listener.getMargin(position);
        holder.setValue(this.photoItems.get(position), this.getSelectedIndex(this.photoItems.get(position)) + 1, marginBox);
    }

    public int getItemViewType(int position) {
        return this.size;
    }

    public int getItemCount() {
        return this.photoItems.size();
    }

    private int getSelectedIndex(PhotoItem photoItem) {
        if (photoItem == null) {
            return -1;
        }
        for (int i = 0; i < this.selectedItems.size(); ++i) {
            PhotoItem item = this.selectedItems.get(i);
            if (item.getId() != photoItem.getId()) continue;
            return i;
        }
        return -1;
    }

    void setImageSize(int size) {
        this.size = size;
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.photoItems.clear();
        this.notifyDataSetChanged();
    }

    public void addAll(List<PhotoItem> photoItems) {
        int startIndex = this.photoItems.size();
        this.photoItems.addAll(startIndex, photoItems);
        this.notifyItemRangeInserted(startIndex, photoItems.size());
    }

    ArrayList<String> getSelectedNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (PhotoItem item : this.selectedItems) {
            list.add(item.getPath());
        }
        return list;
    }

    @Override
    public void clicked(String path) {
        if (this.listener != null) {
            this.listener.onePhotoSelected(path);
        }
    }

    @Override
    public int requestCheck(int position, boolean state) {
        PhotoItem item = this.photoItems.get(position);
        int index = this.getSelectedIndex(item);
        if (state) {
            if (index < 0 && this.selectedItems.size() < 20) {
                this.selectedItems.add(item);
                if (this.listener != null) {
                    this.listener.photoSelected(this.selectedItems.size());
                }
                return this.selectedItems.size();
            }
        } else if (index >= 0) {
            this.selectedItems.remove(index);
            if (this.listener != null) {
                this.listener.photoSelected(this.selectedItems.size());
            }
            for (int i = index; i < this.selectedItems.size(); ++i) {
                this.notifyItemChanged(this.selectedItems.get(i).getIndex());
            }
            return 0;
        }
        return -1;
    }

    public void resetSelection() {
        this.selectedItems.clear();
    }

    void startFetchPhoto() {
        if (this.loading) {
            return;
        }
        new ImageTask().execute(new Context[]{this.activity});
    }

    private void fetchCallback(boolean flag) {
        if (flag) {
            HashSet<Long> set = new HashSet<Long>();
            for (PhotoItem item : this.tempItems) {
                set.add(item.getId());
            }
            for (int i = this.selectedItems.size() - 1; i >= 0; --i) {
                if (set.contains(this.selectedItems.get(i).getId())) continue;
                this.selectedItems.remove(i);
            }
            this.photoItems = this.tempItems;
            this.notifyDataSetChanged();
            if (this.listener != null) {
                this.listener.photoFetchSucceeded(this.photoItems.size());
                this.listener.photoSelected(this.selectedItems.size());
            }
        } else if (this.listener != null) {
            this.listener.photoFetchFailed();
        }
    }

    private class ImageTask
    extends AsyncTask<Context, Void, Boolean> {
        private ImageTask() {
        }

        protected Boolean doInBackground(Context ... params) {
            if (params.length != 1) {
                return false;
            }
            String[] projection = new String[]{"_id", "_display_name", "_data", "bucket_display_name"};
            Context context = params[0];
            Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, null, null, "date_added");
            if (cursor == null) {
                return false;
            }
            PhotoPickerAdapter.this.tempItems = new ArrayList();
            int index = 0;
            if (cursor.moveToLast()) {
                do {
                    long id2 = cursor.getLong(cursor.getColumnIndex(projection[0]));
                    String name = cursor.getString(cursor.getColumnIndex(projection[1]));
                    String path = cursor.getString(cursor.getColumnIndex(projection[2]));
                    File file = new File(path);
                    if (!file.exists()) continue;
                    PhotoPickerAdapter.this.tempItems.add(new PhotoItem(id2, name, path, index++));
                } while (cursor.moveToPrevious());
            }
            cursor.close();
            return true;
        }

        protected void onPostExecute(Boolean flag) {
            super.onPostExecute((Object)flag);
            PhotoPickerAdapter.this.fetchCallback(flag != null ? flag : false);
            PhotoPickerAdapter.this.loading = false;
        }
    }
}

