/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatAction;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapter;
import com.zoyi.channel.plugin.android.activity.chat.listener.ChatActionCallback;
import com.zoyi.channel.plugin.android.activity.chat.listener.MessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ActionMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.QuestionMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.ChatState;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumActivity;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerActivity;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.MenuPosition;
import com.zoyi.channel.plugin.android.enumerate.MenuState;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.view.handler.BackgroundToucher;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.TimeZone;

public class ChatActivity
extends BaseActivity
implements ChatActionCallback,
MessageClickListener {
    private String chatId;
    private RecyclerView recyclerView;
    private WatchedEditText editChat;
    private Button buttonSend;
    private ImageButton buttonAttach;
    private View toast;
    private View chatLayout;
    private ChatAdapter adapter;
    private ChatAction action;
    private LinearLayoutManager layoutManager;
    private ChatState chatState = ChatState.USER_CHAT_NOT_LOADED;
    private Queue<SendingMessageItem> sendQueue;
    private boolean sending = false;
    private UserChat userChat = null;
    private int chatCount = 0;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_chat);
        this.sendQueue = new LinkedList<SendingMessageItem>();
        this.chatLayout = this.findViewById(R.id.chat_layout);
        this.editChat = (WatchedEditText)this.findViewById(R.id.edit_chat);
        this.buttonSend = (Button)this.findViewById(R.id.button_send);
        this.buttonAttach = (ImageButton)this.findViewById(R.id.button_attach);
        this.toast = this.findViewById(R.id.layout_toast);
        this.findViewById(R.id.button_close_toast).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChatActivity.this.adapter != null) {
                    ChatActivity.this.adapter.setNewMessageDismiss();
                    ChatActivity.this.setAlertState(-1);
                }
            }
        });
        this.editChat.setHandledButton(this.buttonSend, ContextCompat.getColor((Context)this, (int)R.color.ch_cobalt), ContextCompat.getColor((Context)this, (int)R.color.ch_gray));
        this.buttonSend.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatActivity.this.sendTextMessage();
            }
        });
        this.buttonAttach.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatActivity.this.hideKeyboard(ChatActivity.this.editChat);
                IntentUtils.setNextActivity((Context)ChatActivity.this, PhotoPickerActivity.class).startActivityForResult(902);
            }
        });
        int requestCode = this.getRequestCode();
        this.getBigBar().withActivity(this).addMenu(ActionType.BACK, MenuPosition.LEFT, Const.USER_CHATS_IS_EMPTY != requestCode ? MenuState.VISIBLE : MenuState.HIDDEN).addMenu(ActionType.EXIT, MenuPosition.LEFT, Const.USER_CHATS_IS_EMPTY == requestCode ? MenuState.VISIBLE : MenuState.HIDDEN).addText(MenuPosition.LEFT).addMenu(ActionType.REFRESH, MenuPosition.RIGHT, MenuState.HIDDEN).build();
        if (this.getIntent() != null) {
            this.chatId = this.getIntent().getStringExtra("chatId");
            this.chatCount = this.getIntent().getIntExtra("chatCount", 0);
            this.getBigBar().setText(this.chatCount);
        }
        TimeUtils.OFFSET = TimeZone.getDefault().getRawOffset();
        this.action = new ChatAction(this);
        this.setStyle();
    }

    public void onBackPressed() {
        if (this.chatId == null) {
            this.setResult(Const.CLOSE_USER_CHATS);
        }
        this.finish();
    }

    private void setStyle() {
        Channel channel = ChannelStore.getChannel();
        if (channel == null) {
            this.finish();
        } else {
            this.chatLayout.setVisibility(0);
            this.setAdapter(channel.getBackgroundColor(), channel.getTextColor());
            this.setStatusBarColor(channel.getBackgroundColor());
            this.getBigBar().setTheme(channel.getBackgroundColor(), channel.getTextColor());
            this.getBigBar().setTitle(channel.getName());
            this.fetchUserChat();
        }
    }

    private void setAdapter(int backColor, int textColor) {
        if (this.adapter == null) {
            this.adapter = new ChatAdapter(this, backColor, textColor);
            this.layoutManager = new LinearLayoutManager((Context)this);
            this.layoutManager.setStackFromEnd(true);
            this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_chat);
            this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
            this.recyclerView.setItemAnimator(null);
            this.recyclerView.getRecycledViewPool().setMaxRecycledViews(MessageType.VERIFY.toInt(), 1);
            this.recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new InfiniteScrollListener(this.layoutManager, 1){

                @Override
                public void refresh() {
                    ChatActivity.this.adapter.loadMore(false);
                }

                @Override
                public void firstItem(int index) {
                    ChatActivity.this.setAlertState(index);
                }
            });
            BackgroundToucher.makeKeyboardEvent(this, this.recyclerView, this.editChat);
        }
    }

    private void fetchUserChat() {
        if (this.chatId != null) {
            this.startProcess(ChatState.USER_CHAT_LOADING);
            if (this.userChat == null) {
                this.showProgress(ResUtils.getString((Context)this, "ch.loading_information"));
            }
            this.action.fetchUserChat(this.chatId);
        } else {
            this.startProcess(ChatState.USER_CHAT_NOT_LOADED);
            this.adapter.addWelcomeMessage();
        }
    }

    @Override
    public void userChatFetched(UserChatWrapper userChatWrapper) {
        this.hideProgress();
        if (ChatState.USER_CHAT_LOADING.equals((Object)this.chatState)) {
            if (userChatWrapper == null) {
                this.stopProcess(ChatState.USER_CHAT_NOT_LOADED);
            } else {
                this.userChat = userChatWrapper.getUserChat();
                if (this.userChat != null) {
                    this.chatId = this.userChat.getId();
                    this.adapter.addMetaDatas(userChatWrapper.getManagers(), null);
                    this.adapter.setSession(userChatWrapper.getSession());
                    this.getBigBar().setMenuState(ActionType.EXIT, MenuState.HIDDEN);
                    this.getBigBar().setMenuState(ActionType.BACK, MenuState.VISIBLE);
                    if (SocketManager.isReady()) {
                        this.startProcess(ChatState.CHAT_JOINING);
                        SocketManager.joinChat(this.chatId);
                    } else {
                        this.startProcess(ChatState.WAITING_SOCKET);
                        SocketManager.reconnect();
                    }
                    this.send(null);
                }
            }
        }
    }

    private void fetchMessages() {
        this.startProcess(ChatState.MESSAGES_LOADING);
        this.adapter.init();
    }

    void messagesFetchComplete(boolean successed, boolean init) {
        if (ChatState.MESSAGES_LOADING.equals((Object)this.chatState)) {
            if (successed) {
                this.adapter.enableReceiveSocket();
                this.startProcess(ChatState.CHAT_READY);
                this.action.readAll(this.chatId);
                if (init) {
                    this.scroll(true);
                }
            } else {
                this.adapter.disableReceiveSocket();
                this.stopProcess(ChatState.MESSAGES_NOT_LOADED);
            }
        }
    }

    private void refresh() {
        switch (this.chatState) {
            case USER_CHAT_NOT_LOADED: {
                this.fetchUserChat();
                break;
            }
            case WAITING_SOCKET: {
                this.startProcess(ChatState.WAITING_SOCKET);
                SocketManager.reconnect();
                break;
            }
            case NOT_JOINED: {
                this.startProcess(ChatState.CHAT_JOINING);
                SocketManager.joinChat(this.chatId);
                break;
            }
            case MESSAGES_NOT_LOADED: {
                this.fetchMessages();
            }
        }
    }

    public void scroll(boolean force) {
        if (this.layoutManager.findLastCompletelyVisibleItemPosition() == this.adapter.getItemCount() - 2 || force) {
            this.layoutManager.scrollToPosition(this.adapter.getItemCount() - 1);
        }
    }

    private void sendTextMessage() {
        String message = StringUtils.stripEnd(this.editChat.getString(), null);
        this.editChat.setText("");
        if ("".equals(message)) {
            return;
        }
        SendingMessageItem item = new SendingMessageItem(message, false);
        this.adapter.addSendingMessage(item);
        this.scroll(true);
        this.send(Collections.singletonList(item));
    }

    private void sendImageFiles(List<String> imageList) {
        ArrayList<SendingMessageItem> items = new ArrayList<SendingMessageItem>();
        if (imageList != null) {
            for (String p : imageList) {
                SendingMessageItem item = new SendingMessageItem(p, true);
                this.adapter.addSendingMessage(item);
                items.add(item);
            }
        }
        this.scroll(true);
        this.send(items);
    }

    private void send(List<SendingMessageItem> list) {
        if (list != null) {
            for (SendingMessageItem item : list) {
                this.sendQueue.offer(item);
            }
            L.i("Send: " + (Object)((Object)this.chatState) + " " + list.size());
        }
        if (ChatState.USER_CHAT_NOT_LOADED.equals((Object)this.chatState)) {
            if (this.chatId != null) {
                this.fetchUserChat();
            } else {
                this.startProcess(ChatState.USER_CHAT_LOADING);
                this.showProgress(ResUtils.getString((Context)this, "ch.loading_information"));
                this.action.createUserChat();
            }
        } else if (!ChatState.USER_CHAT_LOADING.equals((Object)this.chatState) && !this.sending && this.sendQueue.size() > 0) {
            this.sending = true;
            SendingMessageItem item = this.sendQueue.poll();
            if (item.isImage()) {
                this.action.uploadFile(this.chatId, item);
            } else {
                this.action.sendMessage(this.chatId, item);
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 902: {
                if (resultCode != 12) break;
                this.sendImageFiles(data.getStringArrayListExtra("PHOTO_INTENT_KEY"));
            }
        }
    }

    @Override
    public void receiveMessage(Message message) {
        if (message != null) {
            this.receiveData(message, true);
        }
        this.sending = false;
        this.send(null);
    }

    @Override
    public void receiveData(ChannelModel channelModel, boolean upsert) {
        if (this.chatId != null && channelModel != null) {
            switch (channelModel.getClass().getSimpleName()) {
                case "Message": {
                    Message message = (Message)channelModel;
                    boolean added = this.adapter.addMessage(message);
                    if (!added) break;
                    this.scroll(message.isUserMessage());
                    this.action.readAll(this.chatId);
                    break;
                }
                case "File": 
                case "WebPage": 
                case "Bot": 
                case "Manager": {
                    this.adapter.addMetaData(channelModel);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void receiveCommand(Command command, Object object) {
        L.i("ReceiveCommand: " + command.name());
        switch (command) {
            case READY: {
                if (ChatState.WAITING_SOCKET.equals((Object)this.chatState)) {
                    this.startProcess(ChatState.CHAT_JOINING);
                    SocketManager.joinChat(this.chatId);
                    return;
                }
                this.refresh();
                return;
            }
            case JOINED: {
                if (object == null || CompareUtils.compare(this.chatId, (String)object) != 0 || !ChatState.CHAT_JOINING.equals((Object)this.chatState)) return;
                this.fetchMessages();
                return;
            }
            case LEAVED: {
                if (object == null || CompareUtils.compare(this.chatId, (String)object) != 0 || !ChatState.CHAT_READY.equals((Object)this.chatState)) return;
                this.stopProcess(ChatState.NOT_JOINED);
                if (this.adapter == null) return;
                this.adapter.disableReceiveSocket();
                return;
            }
            case SOCKET_DISCONNECTED: {
                switch (this.chatState) {
                    case WAITING_SOCKET: 
                    case NOT_JOINED: 
                    case MESSAGES_NOT_LOADED: 
                    case USER_CHAT_LOADING: 
                    case MESSAGES_LOADING: 
                    case CHAT_JOINING: 
                    case CHAT_READY: {
                        this.stopProcess(ChatState.USER_CHAT_NOT_LOADED);
                        if (this.adapter == null) return;
                        this.adapter.disableReceiveSocket();
                    }
                }
            }
        }
    }

    @Override
    public void receiveChatCounter(int count) {
        this.getBigBar().setText(count);
    }

    @Override
    public void optionClicked(ActionType actionType) {
        super.optionClicked(actionType);
        switch (actionType) {
            case REFRESH: {
                this.refresh();
            }
        }
    }

    void setAlertState(int firstIndex) {
        if (firstIndex == -1) {
            firstIndex = this.layoutManager.findFirstVisibleItemPosition();
        }
        this.toast.setVisibility(UIUtils.getVisible(this.adapter.setNewMessageAlertState(firstIndex), false));
    }

    private void startProcess(ChatState chatState) {
        this.chatState = chatState;
        this.getBigBar().setMenuState(ActionType.REFRESH, MenuState.HIDDEN);
    }

    private void stopProcess(ChatState chatState) {
        this.chatState = chatState;
        this.getBigBar().setMenuState(ActionType.REFRESH, MenuState.VISIBLE);
    }

    @Override
    protected void onDestroy() {
        if (ChatState.CHAT_READY.equals((Object)this.chatState) && this.chatId != null) {
            SocketManager.leaveChat(this.chatId);
        }
        super.onDestroy();
    }

    public String getChatId() {
        return this.chatId;
    }

    @Override
    public void clicked(Message message) {
        if (message.getFile() != null) {
            if (message.getFile().getPreviewThumb() == null || !message.getFile().isImage()) {
                IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", message.getFile().getUrl()).putExtra("filename", message.getFile().getFilename()).putExtra("image", message.getFile().isImage()).startActivity();
            } else {
                IntentUtils.setNextActivity((Context)this, PhotoAlbumActivity.class).putExtra("url", message.getFile().getUrl()).putExtra("filename", message.getFile().getFilename()).putExtra("thumbnailUrl", message.getFile().getPreviewThumb().getUrl()).putExtra("size", message.getFile().getSize()).startActivity();
            }
        } else if (message.getWebPage() != null) {
            this.urlClicked(message.getWebPage().getUrl());
        }
    }

    @Override
    public void actionClicked(ActionMessageItem item) {
        if (item != null && item.getActionType() != null) {
            switch (item.getActionType()) {
                case REQUEST_WORKING_TIME: {
                    item.setActionType(null);
                    this.adapter.addActionMessage(item);
                    QuestionMessageItem questionItem = new QuestionMessageItem(this.adapter.getMax() + 2L, ResUtils.getString((Context)this, "ch.out_of_work.user_answer"));
                    this.adapter.addQuestionMessage(questionItem);
                    this.scroll(true);
                    String workingTime = ChannelStore.getChannel() != null ? ChannelStore.getChannel().getWorkingTime((Context)this) : "?";
                    this.addMessageDelay(new ActionMessageItem(null, null, workingTime));
                }
            }
        }
    }

    @Override
    public void urlClicked(String url) {
        if (url != null) {
            IntentUtils.setUrl((Activity)this, url).startActivity();
        }
    }

    private void addMessageDelay(final ActionMessageItem item) {
        Handler handler = new Handler();
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                item.setTimestamp(ChatActivity.this.adapter.getMax() + 3L);
                ChatActivity.this.adapter.addActionMessage(item);
                ChatActivity.this.scroll(true);
            }
        }, 750L);
    }
}

