package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mika on 2017. 1. 31..
 */
public class WorkingTime {
  private TimeRange sun, mon, tue, wed, thu, fri, sat;

  public String getMessage(Context context) {
    List<String> list = new ArrayList<>();
    list.add(ResUtils.getString(context, "ch.out_of_work.title"));

    addTimeRange(context, list, "sun", sun);
    addTimeRange(context, list, "mon", mon);
    addTimeRange(context, list, "tue", tue);
    addTimeRange(context, list, "wed", wed);
    addTimeRange(context, list, "thu", thu);
    addTimeRange(context, list, "fri", fri);
    addTimeRange(context, list, "sat", sat);

    return StringUtils.join(list, "\n\n");
  }

  private void addTimeRange(Context context, List<String> list, String key, TimeRange timeRange) {
    if (timeRange == null || timeRange.getFrom() == null || timeRange.getTo() == null) {
      return;
    }
    String title = ResUtils.getString(context, "ch.out_of_work." + key);
    String content = getTimeRangeString(timeRange);

    list.add(String.format("%s\n%s", title, content));
  }

  private String getTimeRangeString(TimeRange timeRange) {
    return String.format("%s ~ %s", getTime(timeRange.getFrom()), getTime(timeRange.getTo()));
  }

  private String getTime(int time) {
    time = Math.max(time, 0);
    time = Math.min(time, 1439);

    int hour = time / 60;
    int minute = time % 60;
    String add = hour < 12 ? "AM" : "PM";

    return String.format("%02d:%02d %s", hour > 12 ? hour - 12 : hour, minute, add);
  }
}
