package com.zoyi.channel.plugin.android.global;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

/**
 * Created by mika on 2017. 1. 16..
 */
public class PrefSupervisor {
  private static final String VEIL_ID = "X-Veil-Id";

  private static SharedPreferences getPreferences(Context context) {
    return context.getSharedPreferences("CHANNEL_PLUGIN_PRIVATE_DATA", 0);
  }

  public static String getVeilId(Context context) {
    if (context != null) {
      return getPreferences(context).getString(VEIL_ID, null);
    }
    return null;
  }

  public static void setVeilId(Context context, String veilId) {
    if (context != null) {
      SharedPreferences.Editor editor = getPreferences(context).edit();
      editor.putString(VEIL_ID, veilId);
      editor.apply();
    }
  }
}
