package com.zoyi.channel.plugin.android.activity.userchat_list;

import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.activity.base.SortedItem;
import com.zoyi.channel.plugin.android.model.rest.*;

import java.util.*;

/**
 * Created by mika on 2016. 12. 6..
 */
class UserChatItem implements SortedItem {
  private UserChatListDataDictionary dictionary;
  private UserChat userChat;
  private Session session;
  private ReferMessage message;
  private Set<String> profiles;

  UserChatItem(UserChat userChat, UserChatListDataDictionary dictionary) {
    this.userChat = userChat;
    this.dictionary = dictionary;
    this.message = dictionary.get(ReferMessage.class, userChat.getLastMessageId());
    this.session = dictionary.get(Session.class, userChat.getSessionId());
    this.profiles = new HashSet<>(userChat.getTalkedManagerIds());
  }

  void setUserChat(UserChat userChat) {
    this.userChat = userChat;
    this.message = dictionary.get(ReferMessage.class, userChat.getLastMessageId());
    this.session = dictionary.get(Session.class, userChat.getSessionId());
    this.profiles = new HashSet<>(userChat.getTalkedManagerIds());
  }

  Long getUpdatedAt() {
    if (userChat != null) {
      return userChat.getUpdatedAt();
    }
    return 0L;
  }

  String getId() {
    if (userChat != null) {
      return userChat.getId();
    }
    return "";
  }

  List<? extends ProfileEntity> getProfiles() {
    if (profiles == null || profiles.size() == 0) {
      return Collections.singletonList(ChannelStore.getChannel());
    }

    List<ProfileEntity> list = new ArrayList<>();
    for (String id : profiles) {
      list.add(dictionary.get(Manager.class, id));
    }
    return list;
  }

  UserChat getUserChat() {
    return userChat;
  }

  String getSessionId() {
    if (userChat != null) {
      return userChat.getSessionId();
    }
    return "";
  }

  Session getSession() {
    return session;
  }

  Message getMessage() {
    return message;
  }

  boolean containsManager(String managerId) {
    return profiles != null && profiles.contains(managerId);
  }

  @Override
  public Long getFirst() {
    if (userChat != null) {
      return userChat.getUpdatedAt();
    }
    return 0L;
  }

  @Override
  public String getSecond() {
    if (userChat != null) {
      return userChat.getId();
    }
    return "";
  }

  void setSession(Session session) {
    this.session = session;
  }
}
