package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.L;

/**
 * Created by mika on 2016. 12. 21..
 */
public class ActivityLifecycleManager implements Application.ActivityLifecycleCallbacks {
  private int running = 0;

  @Override
  public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    L.i("onStart: " + activity.getClass().getSimpleName());
    if (activity instanceof UserChatListActivity) {
      ChannelStore.setMainRunning(true);
    }
  }

  @Override
  public void onActivityStarted(Activity activity) {
    L.d("Started: " + activity.getClass().getSimpleName() + " " + running + " -> " + (running + 1));
    if (++running == 1) {
      SocketManager.connect();
    }
  }

  @Override
  public void onActivityResumed(Activity activity) {
  }

  @Override
  public void onActivityPaused(Activity activity) {
  }

  @Override
  public void onActivityStopped(Activity activity) {
    L.d("Stopped: " + activity.getClass().getSimpleName() + " " + running + " -> " + (running - 1));
    if (--running == 0) {
      SocketManager.disconnect();
    }
  }

  @Override
  public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

  }

  @Override
  public void onActivityDestroyed(Activity activity) {
    L.i("onDestroy: " + activity.getClass().getSimpleName());
    if (activity instanceof UserChatListActivity) {
      ChannelStore.setMainRunning(false);
    }
  }
}
