/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.model;

import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;

public class SendingMessageItem
implements MessageItem {
    private String requestId;
    private String string;
    private boolean image;
    private boolean sending;
    private Long createdAt;
    private static int count = 0;

    public SendingMessageItem() {
    }

    public SendingMessageItem(String string, boolean image) {
        long now = System.currentTimeMillis() * 10L + (long)(++count % 10);
        this.string = string;
        this.image = image;
        this.requestId = String.valueOf(now);
        this.createdAt = now;
        this.sending = true;
    }

    @Override
    public Long getFirst() {
        return this.createdAt;
    }

    @Override
    public String getSecond() {
        return this.requestId;
    }

    @Override
    public MessageType getType() {
        return MessageType.SENDING;
    }

    public boolean isSending() {
        return this.sending;
    }

    public void setSending(boolean sending) {
        this.sending = sending;
    }

    public String getString() {
        return this.string;
    }

    public boolean isImage() {
        return this.image;
    }

    public static SendingMessageItem create(String requestId, String channelId, String chatId) {
        SendingMessageItem message = new SendingMessageItem();
        message.requestId = requestId;
        try {
            message.createdAt = Long.parseLong(requestId);
        }
        catch (Exception ex) {
            return null;
        }
        return message;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getMessage() {
        return this.string;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }
}

