package com.zoyi.channel.plugin.android.activity.chat.model;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;

/**
 * Created by mika on 2016. 12. 22..
 */
public class SendingMessageItem implements MessageItem {
  private String requestId;
  private String string;
  private boolean image;
  private boolean sending;
  private Long createdAt;

  public SendingMessageItem() {
  }

  public SendingMessageItem(String string, boolean image) {
    super();
    count++;
    long now = System.currentTimeMillis() * 10 + (count % 10);
    this.string = string;
    this.image = image;
    this.requestId = String.valueOf(now);
    this.createdAt = now;
    this.sending = true;
  }

  @Override
  public Long getFirst() {
    return createdAt;
  }

  @Override
  public String getSecond() {
    return requestId;
  }

  @Override
  public MessageType getType() {
    return MessageType.SENDING;
  }

  public boolean isSending() {
    return sending;
  }

  public void setSending(boolean sending) {
    this.sending = sending;
  }

  public String getString() {
    return string;
  }

  public boolean isImage() {
    return image;
  }

  public static SendingMessageItem create(String requestId, String channelId, String chatId) {
    SendingMessageItem message = new SendingMessageItem();
    message.requestId = requestId;
    try {
      message.createdAt = Long.parseLong(requestId);
    } catch (Exception ex) {
      return null;
    }
    return message;
  }

  public String getRequestId() {
    return requestId;
  }

  public String getMessage() {
    return string;
  }

  public Long getCreatedAt() {
    return createdAt;
  }

  private static int count = 0;
}
