package com.zoyi.channel.plugin.android.activity.base;

import android.Manifest;
import android.annotation.TargetApi;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.ChannelModelBus;
import com.zoyi.channel.plugin.android.event.ChatCounterBus;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;

/**
 * Created by mika on 2016. 12. 5..
 */
public class BaseActivity extends AppCompatActivity {
  private BigBar bigBar;
  private ProgressDialog progressDialog;
  private Subscription subscription;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    if (savedInstanceState != null) {
      finish();
    }
    subscription = RxBus.observable()
        .onBackpressureBuffer()
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(new Action1<Object>() {
      @Override
      public void call(Object o) {
        if (o instanceof CommandBus) {
          CommandBus commandBus = (CommandBus) o;
          receiveCommand(commandBus.getCommand(), commandBus.getObject());
        }
        if (o instanceof ChannelModelBus) {
          ChannelModelBus channelModelBus = (ChannelModelBus) o;
          receiveData(channelModelBus.getChannelModel(), channelModelBus.isUpsert());
        }
        if (o instanceof ChatCounterBus) {
          ChatCounterBus chatCounterBus = (ChatCounterBus) o;
          receiveChatCounter(chatCounterBus.getCounter());
        }
      }
    });
  }

  @Override
  protected void onDestroy() {
    if (subscription != null && !subscription.isUnsubscribed()) {
      subscription.unsubscribe();
    }
    super.onDestroy();
  }

  protected void init(int layoutId) {
    setContentView(layoutId);
    bigBar = (BigBar) findViewById(R.id.big_bar);
  }

  public int getBackgroundColor() {
    Channel channel = ChannelStore.getChannel();
    if (channel != null) {
      return channel.getBackgroundColor();
    }
    return Color.BLACK;
  }

  public int getTextColor() {
    Channel channel = ChannelStore.getChannel();
    if (channel != null) {
      return channel.getTextColor();
    }
    return Color.WHITE;
  }

  protected BigBar getBigBar() {
    return bigBar;
  }

  protected void showProgress(String message) {
    hideProgress();
    progressDialog = ProgressDialog.show(this, "", message, true);
  }

  protected void changeProgress(String message) {
    try {
      if (progressDialog != null && progressDialog.isShowing()) {
        progressDialog.setMessage(message);
      }
    } catch (Exception ignored) {
    }
  }

  protected void hideProgress() {
    try {
      if (progressDialog != null && progressDialog.isShowing()) {
        progressDialog.dismiss();
      }
    } catch (Exception ignored) {
    }
  }

  protected void setStatusBarColor(int color) {
    try {
      if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
        getWindow().setStatusBarColor(Utils.addBlackMask(color));
      }
    } catch (Exception ignored) {
    }
  }

  public void optionClicked(ActionType actionType) {
    switch (actionType) {
      case BACK:
      case EXIT:
        onBackPressed();
        break;
    }
  }

  public void hideKeyboard(EditText editText) {
    InputMethodManager inputManager
        = (InputMethodManager) this.getSystemService(Context.INPUT_METHOD_SERVICE);

    inputManager.hideSoftInputFromWindow(
        editText.getWindowToken(),
        InputMethodManager.HIDE_NOT_ALWAYS);
  }

  protected Integer getRequestCode() {
    if (getIntent() != null) {
      return getIntent().getIntExtra(Const.REQUEST_CODE_INTENT_KEY, Integer.MIN_VALUE);
    }
    return null;
  }

  public void receiveCommand(Command command, Object object) { }

  public void receiveData(ChannelModel channelModel, boolean upsert) { }

  public void receiveChatCounter(int count) { }

  // permission

  protected static final int PERMISSION_READ_STORAGE = 1;
  protected static final int PERMISSION_WRITE_STORAGE = 2;
  protected static final int PERMISSION_CAMERA = 3;
  protected static final int PERMISSION_CALL_PHONE = 4;

  @TargetApi(Build.VERSION_CODES.M)
  private String getPermission(int requestCode) {
    switch (requestCode) {
      case PERMISSION_READ_STORAGE:
        return Manifest.permission.READ_EXTERNAL_STORAGE;
      case PERMISSION_WRITE_STORAGE:
        return Manifest.permission.WRITE_EXTERNAL_STORAGE;
      case PERMISSION_CAMERA:
        return Manifest.permission.CAMERA;
      case PERMISSION_CALL_PHONE:
        return Manifest.permission.CALL_PHONE;
    }

    return "";
  }

  protected boolean checkPermission(int... requestCodes) {
    if (requestCodes.length == 0 || Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
      return true;
    }

    String[] requestStr = new String[requestCodes.length];
    int count = 0;

    for (int i = 0; i < requestCodes.length; i++) {
      requestStr[i] = getPermission(requestCodes[i]);
      if (ContextCompat.checkSelfPermission(this, requestStr[i]) == PackageManager.PERMISSION_GRANTED) {
        count++;
      }
    }

    if (count == requestCodes.length) {
      return true;
    }

    ActivityCompat.requestPermissions(this, requestStr, requestCodes[0]);
    return false;
  }

  @Override
  public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] results) {
    for (int result : results) {
      if (result != PackageManager.PERMISSION_GRANTED) {
        permissionRejected(requestCode);
        return;
      }
    }
    permissionAccepted(requestCode);
  }

  protected void permissionAccepted(int requestCode) {
  }

  protected void permissionRejected(int requestCode) {
  }
}
