/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.zoyi.channel.plugin.android.util.L;
import java.io.Serializable;

public class IntentUtils {
    private Context context;
    private Intent intent;

    public static IntentUtils setNextActivity(Fragment fragment, Class<?> clazz) {
        return IntentUtils.setNextActivity((Context)fragment.getActivity(), clazz);
    }

    public static IntentUtils setNextActivity(Context context, Class<?> clazz) {
        IntentUtils intentUtils = new IntentUtils();
        intentUtils.context = context;
        intentUtils.intent = new Intent(context, clazz);
        return intentUtils;
    }

    public IntentUtils() {
    }

    private IntentUtils(Context context, Intent intent) {
        this.context = context;
        this.intent = intent;
    }

    public IntentUtils putExtra(String key, Integer value) {
        if (value != null) {
            this.intent.putExtra(key, (Serializable)value);
        }
        return this;
    }

    public IntentUtils putExtra(String key, Long value) {
        if (value != null) {
            this.intent.putExtra(key, (Serializable)value);
        }
        return this;
    }

    public IntentUtils putExtra(String key, String value) {
        if (value != null) {
            this.intent.putExtra(key, value);
        }
        return this;
    }

    public IntentUtils putExtra(String key, Boolean value) {
        if (value != null) {
            this.intent.putExtra(key, (Serializable)value);
        }
        return this;
    }

    public void startActivity() {
        if (this.context != null && this.intent != null) {
            try {
                this.context.startActivity(this.intent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static IntentUtils setUrl(Activity activity, String url) {
        IntentUtils intentUtils = new IntentUtils((Context)activity, new Intent("android.intent.action.VIEW"));
        try {
            Uri uri = Uri.parse((String)url);
            if (uri.getScheme() == null || uri.getScheme().isEmpty()) {
                uri = Uri.parse((String)("http://" + url));
            }
            intentUtils.intent.setData(uri);
        }
        catch (Exception ex) {
            L.e(ex.getMessage());
            intentUtils.intent = null;
        }
        return intentUtils;
    }

    public void startActivityForResult(int requestCode) {
        if (this.context instanceof Activity) {
            this.intent.putExtra("REQUEST_CODE_INTENT_KEY", requestCode);
            ((Activity)this.context).startActivityForResult(this.intent, requestCode);
        }
    }
}

