package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.model.wrapper.*;
import com.zoyi.retrofit2.http.*;
import com.zoyi.retrofit2.okhttp3.MultipartBody;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.rx.Observable;

import java.util.Map;

/**
 * Created by mika on 2016. 1. 20..
 */
public interface ChannelApi {
  @GET("packages/{packageId}/versions/latest")
  Observable<PackageWrapper> getLastestPackage(@Path("packageId") String packageId, @Query("from") String from);

  @Headers({"Content-Type: application/json"})
  @POST("/app/plugins/{key}/check_in")
  Observable<PluginWrapper> checkIn(@HeaderMap Map<String, String> headers, @Path("key") String key, @Query("url") String url, @Body RequestBody body);

  @GET("/app/plugins/{key}")
  Observable<PluginWrapper> getPlugin(@Path("key") String key);

  @GET("/app/scripts")
  Observable<ScriptsWrapper> getScripts();

  @GET("/app/user_chats")
  Observable<UserChatsWrapper> getUserChats(@Query("sortField") String sortField, @Query("sortOrder") String sortOrder, @Query("limit") Integer limit);

  @GET("/app/user_chats/{userChatId}")
  Observable<UserChatWrapper> getUserChat(@Path("userChatId") String userChatId);

  @GET("/app/user_chats/{userChatId}/messages")
  Observable<MessagesWrapper> getMessages(@Path("userChatId") String userChatId, @Query("since") String since, @Query("limit") Integer limit, @Query("sortOrder") String sortOrder);

  @POST("/app/user_chats")
  Observable<UserChatWrapper> createUserChat(@Header("X-Plugin-Key") String key);

  @PUT("/app/user_chats/{userChatId}/messages/read_all")
  Observable<Void> readAll(@Path("userChatId") String userChatId);

  @Headers({"Content-Type: application/json"})
  @POST("/app/user_chats/{userChatId}/messages")
  Observable<MessageWrapper> sendMessage(@Path("userChatId") String userChatId, @Body RequestBody body);

  @Multipart
  @POST("/app/user_chats/{userChatId}/messages/file")
  Observable<MessageWrapper> uploadFile(@Path("userChatId") String userChatId, @Part MultipartBody.Part file, @Part("requestId") RequestBody requestId);

  @Headers({"Content-Type: application/json"})
  @PUT("/app/guests")
  Observable<UserVeilWrapper> updateGuest(@Body RequestBody body);
}
