/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Observer;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class OperatorOnBackpressureLatest<T>
implements Observable.Operator<T, T> {
    public static <T> OperatorOnBackpressureLatest<T> instance() {
        return Holder.INSTANCE;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        LatestEmitter<? super T> producer = new LatestEmitter<T>(child);
        LatestSubscriber<? super T> parent = new LatestSubscriber<T>(producer);
        producer.parent = parent;
        child.add(parent);
        child.add(producer);
        child.setProducer(producer);
        return parent;
    }

    static final class LatestSubscriber<T>
    extends Subscriber<T> {
        private final LatestEmitter<T> producer;

        LatestSubscriber(LatestEmitter<T> producer) {
            this.producer = producer;
        }

        @Override
        public void onStart() {
            this.request(0L);
        }

        @Override
        public void onNext(T t) {
            this.producer.onNext(t);
        }

        @Override
        public void onError(Throwable e) {
            this.producer.onError(e);
        }

        @Override
        public void onCompleted() {
            this.producer.onCompleted();
        }

        void requestMore(long n) {
            this.request(n);
        }
    }

    static final class LatestEmitter<T>
    extends AtomicLong
    implements Producer,
    Subscription,
    Observer<T> {
        private static final long serialVersionUID = -1364393685005146274L;
        final Subscriber<? super T> child;
        LatestSubscriber<? super T> parent;
        final AtomicReference<Object> value;
        Throwable terminal;
        volatile boolean done;
        boolean emitting;
        boolean missed;
        static final Object EMPTY = new Object();
        static final long NOT_REQUESTED = -4611686018427387904L;

        public LatestEmitter(Subscriber<? super T> child) {
            this.child = child;
            this.value = new AtomicReference<Object>(EMPTY);
            this.lazySet(-4611686018427387904L);
        }

        @Override
        public void request(long n) {
            if (n >= 0L) {
                long u;
                long r;
                do {
                    if ((r = this.get()) == Long.MIN_VALUE) {
                        return;
                    }
                    if (r == -4611686018427387904L) {
                        u = n;
                        continue;
                    }
                    u = r + n;
                    if (u >= 0L) continue;
                    u = Long.MAX_VALUE;
                } while (!this.compareAndSet(r, u));
                if (r == -4611686018427387904L) {
                    this.parent.requestMore(Long.MAX_VALUE);
                }
                this.emit();
                return;
            }
        }

        long produced(long n) {
            long u;
            long r;
            do {
                if ((r = this.get()) >= 0L) continue;
                return r;
            } while (!this.compareAndSet(r, u = r - n));
            return u;
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get() == Long.MIN_VALUE;
        }

        @Override
        public void unsubscribe() {
            if (this.get() >= 0L) {
                this.getAndSet(Long.MIN_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            this.value.lazySet(t);
            this.emit();
        }

        @Override
        public void onError(Throwable e) {
            this.terminal = e;
            this.done = true;
            this.emit();
        }

        @Override
        public void onCompleted() {
            this.done = true;
            this.emit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void emit() {
            LatestEmitter latestEmitter = this;
            synchronized (latestEmitter) {
                if (this.emitting) {
                    this.missed = true;
                    return;
                }
                this.emitting = true;
                this.missed = false;
            }
            boolean skipFinal = false;
            try {
                while (true) {
                    long r;
                    if ((r = this.get()) == Long.MIN_VALUE) {
                        skipFinal = true;
                        return;
                    }
                    Object v = this.value.get();
                    if (r > 0L && v != EMPTY) {
                        Object v2 = v;
                        this.child.onNext(v2);
                        this.value.compareAndSet(v, EMPTY);
                        this.produced(1L);
                        v = EMPTY;
                    }
                    if (v == EMPTY && this.done) {
                        Throwable e = this.terminal;
                        if (e != null) {
                            this.child.onError(e);
                        } else {
                            this.child.onCompleted();
                        }
                    }
                    LatestEmitter latestEmitter2 = this;
                    synchronized (latestEmitter2) {
                        if (!this.missed) {
                            this.emitting = false;
                            skipFinal = true;
                            return;
                        }
                        this.missed = false;
                    }
                }
            }
            finally {
                if (!skipFinal) {
                    LatestEmitter latestEmitter3 = this;
                    synchronized (latestEmitter3) {
                        this.emitting = false;
                    }
                }
            }
        }
    }

    static final class Holder {
        static final OperatorOnBackpressureLatest<Object> INSTANCE = new OperatorOnBackpressureLatest();

        Holder() {
        }
    }
}

