/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatActivity;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatClickListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatCounter;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActionListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListAdapter;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListPresenter;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListState;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.MenuPosition;
import com.zoyi.channel.plugin.android.enumerate.MenuState;
import com.zoyi.channel.plugin.android.event.ChatCounterBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.ProfileLayout;

public class UserChatListActivity
extends BaseActivity
implements UserChatListActionListener,
UserChatClickListener {
    private RelativeLayout profileLayout;
    private RecyclerView recyclerView;
    private FloatingActionButton fab;
    private LinearLayout profileList;
    private String tempChatId;
    private String runningChatId;
    private UserChatCounter userChatCounter;
    private UserChatListPresenter presenter;
    private UserChatListAdapter adapter;
    private boolean init = false;
    private boolean profileVisible = false;
    private UserChatListState state = UserChatListState.WAITING_SOCKET;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_user_chat_list);
        ((TextView)this.findViewById(R.id.text_powered)).setText((CharSequence)Html.fromHtml((String)this.getString(R.string.ch_plugin_powered_label)));
        this.profileLayout = (RelativeLayout)this.findViewById(R.id.layout_profile);
        this.profileList = (LinearLayout)this.findViewById(R.id.layout_profile_list);
        this.fab = (FloatingActionButton)this.findViewById(R.id.fab);
        this.fab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IntentUtils.setNextActivity((Context)UserChatListActivity.this, ChatActivity.class).putExtra("chatCount", UserChatListActivity.this.userChatCounter.getCounter(UserChatListActivity.this.runningChatId)).startActivity();
            }
        });
        this.fab.hide(false);
        this.profileLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UserChatListActivity.this.setProfileLayout(false);
            }
        });
        this.findViewById(R.id.button_agreement).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String url = "http://channel.io/ko/terms_user?channel=" + (ChannelStore.getChannel() != null ? ChannelStore.getChannel().getName() : "");
                IntentUtils.setUrl((Activity)UserChatListActivity.this, url).startActivity();
            }
        });
        this.getBigBar().withActivity(this).addMenu(ActionType.EXIT, MenuPosition.LEFT).addMenu(ActionType.REFRESH, MenuPosition.RIGHT, MenuState.HIDDEN).addMenu(ActionType.MORE, MenuPosition.RIGHT, MenuState.HIDDEN).build();
        this.presenter = new UserChatListPresenter(this);
        this.adapter = new UserChatListAdapter(this);
        this.userChatCounter = new UserChatCounter();
        if (this.getIntent() != null) {
            this.tempChatId = this.getIntent().getStringExtra("runningChatId");
        }
        LinearLayoutManager manager = new LinearLayoutManager((Context)this);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_view);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)manager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recyclerView.setItemAnimator(null);
        this.recyclerView.getRecycledViewPool().setMaxRecycledViews(0, 40);
        this.recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new InfiniteScrollListener(manager, -1){

            @Override
            public void refresh() {
            }
        });
        this.setStyle();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    protected void onStart() {
        this.runningChatId = null;
        super.onStart();
    }

    public void onBackPressed() {
        if (this.profileVisible) {
            this.setProfileLayout(false);
        } else {
            super.onBackPressed();
        }
    }

    private void setStyle() {
        Channel channel = ChannelStore.getChannel();
        if (channel == null) {
            this.finish();
        } else {
            this.setStatusBarColor(channel.getBackgroundColor());
            this.getBigBar().setTheme(channel.getBackgroundColor(), channel.getTextColor());
            this.getBigBar().setTitle(channel.getName());
            this.fab.setColorNormal(channel.getBackgroundColor());
            this.fab.setColorPressed(Utils.addBlackMask(channel.getBackgroundColor()));
            this.fab.setColorRipple(-1);
            this.fab.setImageResource(channel.getTextColor() == -16777216 ? R.drawable.ch_plugin_ic_add_black_24dp : R.drawable.ch_plugin_ic_add_white_24dp);
            this.fab.attachToRecyclerView(this.recyclerView);
            this.getUserChats();
        }
    }

    private void getUserChats() {
        Channel channel = ChannelStore.getChannel();
        if (channel != null) {
            if (SocketManager.isReady()) {
                if (!this.init) {
                    this.showProgress(ResUtils.getString((Context)this, "ch.loading_information"));
                }
                this.startProcess(UserChatListState.USER_CHAT_LIST_LOADING);
                this.presenter.fetchUserChats(channel.getId());
            } else {
                this.startProcess(UserChatListState.WAITING_SOCKET);
                SocketManager.reconnect();
            }
        }
    }

    @Override
    public void userChatsFetched(UserChatsWrapper userChatsWrapper) {
        this.hideProgress();
        if (userChatsWrapper == null) {
            this.stopProcess(UserChatListState.USER_CHAT_LIST_NOT_LOADED);
        } else {
            this.startProcess(UserChatListState.READY);
            this.adapter.init(userChatsWrapper);
            this.userChatCounter.setList(userChatsWrapper.getSessions());
            RxBus.post(new ChatCounterBus(this.userChatCounter.getCounter(this.runningChatId)));
            this.init = true;
            this.getBigBar().setMenuState(ActionType.MORE, MenuState.VISIBLE);
            if (!this.profileVisible) {
                this.fab.show();
            }
            if (this.tempChatId != null) {
                this.startChat(this.tempChatId);
                this.tempChatId = null;
            } else if (this.adapter.getItemCount() == 0) {
                IntentUtils.setNextActivity((Context)this, ChatActivity.class).startActivityForResult(Const.USER_CHATS_IS_EMPTY);
            }
        }
    }

    private void refresh() {
        switch (this.state) {
            case WAITING_SOCKET: {
                SocketManager.reconnect();
                break;
            }
            case USER_CHAT_LIST_NOT_LOADED: {
                this.getUserChats();
            }
        }
    }

    @Override
    public void receiveCommand(Command command, Object object) {
        L.i((Object)((Object)command) + " " + object);
        switch (command) {
            case READY: {
                if (UserChatListState.WAITING_SOCKET.equals((Object)this.state)) {
                    this.getUserChats();
                    break;
                }
                this.refresh();
                break;
            }
            case JOINED: {
                this.runningChatId = (String)object;
                break;
            }
            case SOCKET_DISCONNECTED: {
                this.stopProcess(UserChatListState.WAITING_SOCKET);
                if (this.adapter == null) break;
                this.adapter.stopRefreshBySocket();
            }
        }
    }

    @Override
    public void receiveData(ChannelModel channelModel, boolean upsert) {
        this.adapter.receiveChannelModel(channelModel, upsert);
        if (channelModel instanceof Session) {
            Session session = (Session)channelModel;
            if (upsert) {
                this.userChatCounter.upsert(session);
            } else {
                this.userChatCounter.delete(session);
            }
            if (session.getId() != null && !CompareUtils.isSame(session.getChatId(), this.runningChatId)) {
                RxBus.post(new ChatCounterBus(this.userChatCounter.getCounter(this.runningChatId)));
            }
        }
    }

    @Override
    public void optionClicked(ActionType actionType) {
        super.optionClicked(actionType);
        switch (actionType) {
            case REFRESH: {
                this.getBigBar().setMenuState(ActionType.REFRESH, MenuState.HIDDEN);
                this.refresh();
                break;
            }
            case MORE: {
                this.toggleProfile();
            }
        }
    }

    private void toggleProfile() {
        this.setProfileLayout(!this.profileVisible);
    }

    private void setProfileLayout(boolean profileVisible) {
        this.profileVisible = profileVisible;
        if (profileVisible) {
            this.fab.hide();
            this.setProfile();
            this.profileLayout.setVisibility(0);
        } else {
            this.fab.show();
            this.profileLayout.setVisibility(8);
        }
    }

    private void setProfile() {
        ProfileLayout profile;
        boolean flag = false;
        this.profileList.removeAllViews();
        User user = ChannelStore.getUser();
        if (user != null && user.getName() != null) {
            flag = true;
            profile = new ProfileLayout((Context)this);
            profile.set(ResUtils.getString((Context)this, "ch.user_profile.user_name"), user.getName());
            this.profileList.addView((View)profile);
        }
        if (ChannelStore.getMobileNumber() != null) {
            flag = true;
            profile = new ProfileLayout((Context)this);
            profile.set(ResUtils.getString((Context)this, "ch.user_profile.mobile_number"), ChannelStore.getMobileNumber());
            this.profileList.addView((View)profile);
        }
        if (!flag) {
            profile = new ProfileLayout((Context)this);
            profile.set(ResUtils.getString((Context)this, "ch.user_profile.empty"), "");
            this.profileList.addView((View)profile);
        }
    }

    @Override
    public void clicked(String chatId) {
        this.startChat(chatId);
    }

    private void startChat(String chatId) {
        this.runningChatId = chatId;
        IntentUtils.setNextActivity((Context)this, ChatActivity.class).putExtra("chatId", chatId).putExtra("chatCount", this.userChatCounter.getCounter(chatId)).startActivity();
    }

    private void startProcess(UserChatListState state) {
        this.state = state;
        this.getBigBar().setMenuState(ActionType.REFRESH, MenuState.HIDDEN);
    }

    private void stopProcess(UserChatListState state) {
        this.state = state;
        this.getBigBar().setMenuState(ActionType.REFRESH, MenuState.VISIBLE);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == Const.CLOSE_USER_CHATS && this.init && this.adapter.getItemCount() == 0) {
            this.finish();
        }
    }
}

