/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.content.Context;
import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.SortedListCallback;
import com.zoyi.channel.plugin.android.activity.chat.ChatAction;
import com.zoyi.channel.plugin.android.activity.chat.ChatActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatDataDictionary;
import com.zoyi.channel.plugin.android.activity.chat.CountryDictionary;
import com.zoyi.channel.plugin.android.activity.chat.listener.MessageCallback;
import com.zoyi.channel.plugin.android.activity.chat.listener.UserInfoListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ActionMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.DateItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumberItem;
import com.zoyi.channel.plugin.android.activity.chat.model.NewMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.QuestionMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.UserInfoItem;
import com.zoyi.channel.plugin.android.activity.chat.type.ActionType;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.type.UserInfoType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ActionMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.DateDividerHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ManagerMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.NewMessageholder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.QuestionMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.UserInfoMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.UserMessageHolder;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.wrapper.MessagesWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserVeilWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ChatAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements UserInfoListener {
    private ChatActivity activity;
    private ChatDataDictionary dictionary;
    private Session session;
    private ChatAction action;
    private boolean init;
    private boolean loading;
    private boolean ready;
    private boolean saveMessage;
    private int fetchCounter = 0;
    private String next = "zzzzzzzzzzzzzzzz";
    private Set<String> messageSet;
    private SortedList<MessageItem> items;
    private int userChatBackColor;
    private int userChatTextColor;
    private boolean isAutoMessageExists = false;
    private Long newMessageTimestamp = null;
    private boolean newMessageDismiss = true;
    private long minTimestamp = Long.MAX_VALUE;
    private long maxTimestamp = Long.MIN_VALUE;
    private String max = "0000000000000000";
    private List<Message> tempQueue;
    private CountryDictionary countryDictionary;
    private UserInfoItem userInfoItem;
    private boolean receiveFirstMessage = false;

    public ChatAdapter(ChatActivity activity, int userChatBackColor, int userChatTextColor) {
        this.activity = activity;
        this.action = new ChatAction(null);
        this.userChatBackColor = userChatBackColor;
        this.userChatTextColor = userChatTextColor;
        this.tempQueue = new ArrayList<Message>();
        this.messageSet = new HashSet<String>();
        this.dictionary = new ChatDataDictionary();
        this.items = new SortedList(MessageItem.class, new SortedListCallback(this, false));
        this.countryDictionary = new CountryDictionary((Context)activity);
    }

    public void init() {
        if (!this.ready && this.activity.getChatId() != null) {
            ++this.fetchCounter;
            this.saveMessage = true;
            this.tempQueue.clear();
            if (this.init && CompareUtils.compare(this.max, "0000000000000000") > 0) {
                this.fetchContinuous(this.max);
            } else {
                this.action.fetchMessages(this.activity.getChatId(), "zzzzzzzzzzzzzzzz", "DESC", this.fetchCounter, new MessageCallback(){

                    @Override
                    public void messagesFetched(int counter, MessagesWrapper wrapper) {
                        if (counter == ChatAdapter.this.fetchCounter) {
                            if (wrapper == null) {
                                ChatAdapter.this.activity.messagesFetchComplete(false);
                            } else {
                                ChatAdapter.this.addMetaDatas(wrapper.getManagers(), wrapper.getBots());
                                ChatAdapter.this.addMessages(wrapper.getNext(), wrapper.getMessages());
                                ChatAdapter.this.addWorkingTimeMessage();
                                ChatAdapter.this.activity.setAlertState(-1);
                                ChatAdapter.this.activity.messagesFetchComplete(true);
                                ChatAdapter.this.init = true;
                            }
                        }
                    }
                });
            }
        }
    }

    private void fetchContinuous(String since) {
        if (this.activity.getChatId() != null) {
            this.action.fetchMessages(this.activity.getChatId(), since, "ASC", this.fetchCounter, new MessageCallback(){

                @Override
                public void messagesFetched(int counter, MessagesWrapper wrapper) {
                    if (counter == ChatAdapter.this.fetchCounter) {
                        if (wrapper == null) {
                            ChatAdapter.this.activity.messagesFetchComplete(false);
                        } else {
                            ChatAdapter.this.addMetaDatas(wrapper.getManagers(), wrapper.getBots());
                            ChatAdapter.this.addMessages(wrapper.getNext(), wrapper.getMessages());
                            if (wrapper.getNext() == null) {
                                ChatAdapter.this.activity.setAlertState(-1);
                                ChatAdapter.this.activity.messagesFetchComplete(true);
                                ChatAdapter.this.init = true;
                            } else {
                                ChatAdapter.this.fetchContinuous(wrapper.getNext());
                            }
                        }
                    }
                }
            });
        }
    }

    public void enableReceiveSocket() {
        this.ready = true;
        L.i("tempQueue");
        this.addMessages(this.tempQueue);
        this.tempQueue.clear();
    }

    public void disableReceiveSocket() {
        this.ready = false;
        this.saveMessage = false;
        ++this.fetchCounter;
        this.tempQueue.clear();
    }

    public void addMetaDatas(List<Manager> managers, List<Bot> bots) {
        this.dictionary.add(managers);
        this.dictionary.add(bots);
    }

    public void addMetaData(ChannelModel model) {
        this.dictionary.add(model);
    }

    public void loadMore(boolean force) {
        if (this.init && this.next != null && (!this.loading || force) && this.activity.getChatId() != null) {
            this.loading = true;
            this.action.fetchMessages(this.activity.getChatId(), this.next, "DESC", this.fetchCounter, new MessageCallback(){

                @Override
                public void messagesFetched(int counter, MessagesWrapper wrapper) {
                    if (ChatAdapter.this.fetchCounter == counter && wrapper != null) {
                        ChatAdapter.this.addMetaDatas(wrapper.getManagers(), wrapper.getBots());
                        ChatAdapter.this.addMessages(wrapper.getNext(), wrapper.getMessages());
                        ChatAdapter.this.activity.setAlertState(-1);
                        ChatAdapter.this.loading = false;
                    }
                }
            });
        }
    }

    public boolean addMessage(Message message) {
        if (!this.receiveFirstMessage) {
            this.receiveFirstMessage = true;
            this.checkRequireUserInfo(message.getCreatedAt() + 1L);
        }
        if (this.ready) {
            return this.addMessages(Collections.singletonList(message));
        }
        if (this.saveMessage) {
            this.tempQueue.add(message);
        }
        return false;
    }

    public boolean addMessages(List<Message> messages) {
        if (this.activity.getChatId() == null) {
            return false;
        }
        ArrayList<MessageItem> items = new ArrayList<MessageItem>();
        int addCount = 0;
        for (Message message : messages) {
            SendingMessageItem item;
            if (message == null || message.getLog() != null) continue;
            items.add(new ChatMessageItem(message));
            items.add(new DateItem(message.getCreatedAt()));
            if (!"Manager".equals(message.getPersonType()) && message.getRequestId() != null && (item = SendingMessageItem.create(message.getRequestId(), message.getChannelId(), message.getChatId())) != null) {
                this.items.remove((Object)item);
            }
            if (!this.messageSet.contains(message.getId())) {
                ++addCount;
                this.messageSet.add(message.getId());
            }
            if (this.minTimestamp > message.getCreatedAt()) {
                this.minTimestamp = message.getCreatedAt();
            }
            if (this.maxTimestamp >= message.getCreatedAt()) continue;
            this.maxTimestamp = message.getCreatedAt();
            this.max = message.getId();
        }
        this.items.addAll(items);
        if (!this.newMessageDismiss && this.newMessageTimestamp != null && this.minTimestamp < this.newMessageTimestamp && this.newMessageTimestamp < this.maxTimestamp) {
            this.items.add((Object)new NewMessageItem(this.newMessageTimestamp));
        }
        if (this.newMessageTimestamp != null && this.newMessageTimestamp >= this.maxTimestamp) {
            this.newMessageDismiss = true;
        }
        return addCount > 0;
    }

    public void addMessages(String next, List<Message> messages) {
        this.next = next;
        this.addMessages(messages);
    }

    public void setNewMessageDismiss() {
        this.newMessageDismiss = true;
    }

    public void setSession(Session session) {
        this.session = session;
        if (this.newMessageTimestamp != null) {
            this.items.remove((Object)new NewMessageItem(this.newMessageTimestamp));
        }
        this.newMessageTimestamp = session.getLastReadAt();
        this.newMessageDismiss = false;
    }

    public boolean setNewMessageAlertState(int firstIndex) {
        if (firstIndex < 0 || firstIndex >= this.items.size() || this.newMessageDismiss) {
            return false;
        }
        Long first = ((MessageItem)this.items.get(firstIndex)).getFirst();
        if (first != null) {
            if (first <= this.newMessageTimestamp) {
                this.newMessageDismiss = true;
                return false;
            }
            return true;
        }
        return false;
    }

    private MessageItem get(int position) {
        if (position < 0 || position >= this.items.size()) {
            return null;
        }
        return (MessageItem)this.items.get(position);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater i = LayoutInflater.from((Context)parent.getContext());
        MessageType type = MessageType.fromId(viewType);
        switch (type) {
            case ACTION_MESSAGE: {
                return new ActionMessageHolder(i.inflate(R.layout.ch_plugin_item_message_manager, parent, false), this.activity, this.dictionary);
            }
            case QUESTION_MESSAGE: {
                return new QuestionMessageHolder(i.inflate(R.layout.ch_plugin_item_message_user, parent, false), this.activity, this.dictionary, this.userChatBackColor, this.userChatTextColor);
            }
            case MANAGER_MESSSAGE: {
                return new ManagerMessageHolder(i.inflate(R.layout.ch_plugin_item_message_manager, parent, false), this.activity, this.dictionary);
            }
            case SENDING: 
            case USER_MESSAGE: {
                return new UserMessageHolder(i.inflate(R.layout.ch_plugin_item_message_user, parent, false), this.activity, this.dictionary, this.userChatBackColor, this.userChatTextColor);
            }
            case DATE: {
                return new DateDividerHolder(i.inflate(R.layout.ch_plugin_item_message_date, parent, false));
            }
            case NEW_MESSAGE_DIVIDER: {
                return new NewMessageholder(i.inflate(R.layout.ch_plugin_item_message_unread_divider, parent, false));
            }
            case USER_INFO: {
                return new UserInfoMessageHolder(i.inflate(R.layout.ch_plugin_item_message_user_info, parent, false), this.countryDictionary, this);
            }
        }
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        MessageItem item = (MessageItem)this.items.get(position);
        switch (item.getType()) {
            case ACTION_MESSAGE: {
                ActionMessageItem actionMessageItem = (ActionMessageItem)item;
                ActionMessageHolder actionMessageHolder = (ActionMessageHolder)holder;
                actionMessageHolder.set(actionMessageItem);
                break;
            }
            case QUESTION_MESSAGE: {
                QuestionMessageItem questionMessageItem = (QuestionMessageItem)item;
                QuestionMessageHolder questionMessageHolder = (QuestionMessageHolder)holder;
                questionMessageHolder.set(questionMessageItem);
                break;
            }
            case MANAGER_MESSSAGE: {
                ChatMessageItem chatMessageItem = (ChatMessageItem)item;
                ManagerMessageHolder managerMessageHolder = (ManagerMessageHolder)holder;
                managerMessageHolder.set(chatMessageItem, chatMessageItem.isConnected(this.get(position - 1)));
                break;
            }
            case USER_MESSAGE: {
                ChatMessageItem chatMessageItem = (ChatMessageItem)item;
                UserMessageHolder userMessageHolder = (UserMessageHolder)holder;
                userMessageHolder.set(chatMessageItem.getMessage(), chatMessageItem.isConnected(this.get(position - 1)));
                break;
            }
            case SENDING: {
                SendingMessageItem sendingMessageItem = (SendingMessageItem)item;
                UserMessageHolder sendingHolder = (UserMessageHolder)holder;
                sendingHolder.set(sendingMessageItem);
                break;
            }
            case DATE: {
                DateDividerHolder dateDividerHolder = (DateDividerHolder)holder;
                dateDividerHolder.set((DateItem)item);
                break;
            }
            case USER_INFO: {
                UserInfoMessageHolder userInfoMessageHolder = (UserInfoMessageHolder)holder;
                userInfoMessageHolder.set(this.userInfoItem);
            }
        }
    }

    public int getItemViewType(int position) {
        return ((MessageItem)this.items.get(position)).getType().toInt();
    }

    public int getItemCount() {
        return this.items.size();
    }

    public Long getMax() {
        return this.maxTimestamp;
    }

    void addSendingMessage(SendingMessageItem item) {
        this.items.add((Object)item);
    }

    void addActionMessage(ActionMessageItem item) {
        this.items.add((Object)item);
    }

    void addQuestionMessage(QuestionMessageItem item) {
        this.items.add((Object)item);
    }

    private void addWorkingTimeMessage() {
        String message;
        if (this.isAutoMessageExists) {
            return;
        }
        if (!ChannelStore.isWorking() && (message = ChannelStore.getScript("out_of_work", "ch.scripts.out_of_work.default")) != null) {
            this.isAutoMessageExists = true;
            this.items.add((Object)new ActionMessageItem(this.maxTimestamp + 1L, ActionType.REQUEST_WORKING_TIME, message));
        }
    }

    public void addWelcomeMessage() {
        if (this.isAutoMessageExists) {
            return;
        }
        if (!ChannelStore.isWorking()) {
            this.addWorkingTimeMessage();
        } else {
            String message;
            User user = ChannelStore.getUser();
            if (user != null && user.getName() != null) {
                message = ChannelStore.getScript("welcome_user", "ch.scripts.welcome_user.default");
                if (message != null) {
                    message = message.replace("${user}", user.getName());
                }
            } else {
                message = ChannelStore.getScript("welcome_veil", "ch.scripts.welcome_veil.default");
            }
            if (message != null) {
                this.items.add((Object)new ActionMessageItem(this.maxTimestamp + 1L, null, message));
            }
        }
    }

    @Override
    public void userInfoChanged(Object object) {
        if (this.userInfoItem != null) {
            switch (this.userInfoItem.getUserInfoType()) {
                case NAME: {
                    if (!(object instanceof String)) break;
                    this.userInfoItem.setObject(object);
                    break;
                }
                case MOBILE_NUMBER: {
                    if (!(object instanceof MobileNumberItem)) break;
                    this.userInfoItem.setObject(object);
                }
            }
        }
    }

    private void checkRequireUserInfo(long timestamp) {
        if (this.userInfoItem != null) {
            try {
                this.items.remove((Object)this.userInfoItem);
                this.userInfoItem = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!ChannelStore.hasName()) {
            this.userInfoItem = new UserInfoItem(UserInfoType.NAME, timestamp, false, null);
        } else if (ChannelStore.getMobileNumber() == null) {
            this.userInfoItem = new UserInfoItem(UserInfoType.MOBILE_NUMBER, timestamp, false, new MobileNumberItem(this.countryDictionary.getDefaultCountryCode(), ""));
        }
        if (this.userInfoItem != null) {
            this.items.add((Object)this.userInfoItem);
        }
    }

    @Override
    public void apply() {
        if (this.userInfoItem != null && this.userInfoItem.getObject() != null) {
            RequestUtils requestUtils = null;
            switch (this.userInfoItem.getUserInfoType()) {
                case NAME: {
                    if (!(this.userInfoItem.getObject() instanceof String)) break;
                    requestUtils = RequestUtils.form().set("name", (String)this.userInfoItem.getObject());
                    break;
                }
                case MOBILE_NUMBER: {
                    if (!(this.userInfoItem.getObject() instanceof MobileNumberItem)) break;
                    MobileNumberItem item = (MobileNumberItem)this.userInfoItem.getObject();
                    requestUtils = RequestUtils.form().set("mobileNumber", String.format("+%s%s", item.getCountry(), item.getMobileNumber()));
                    break;
                }
                default: {
                    return;
                }
            }
            if (requestUtils != null) {
                ChannelPlugin.getApi().updateGuest(requestUtils.create()).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<UserVeilWrapper>(){

                    @Override
                    public void onError(Throwable e) {
                        L.e(e.getMessage());
                        ChatAdapter.this.userInfoItem.setError(true);
                        ChatAdapter.this.items.add((Object)ChatAdapter.this.userInfoItem);
                    }

                    @Override
                    public void onNext(UserVeilWrapper wrapper) {
                        ChannelStore.setUserVeil(wrapper.getUser(), wrapper.getVeil());
                        ChatAdapter.this.items.remove((Object)ChatAdapter.this.userInfoItem);
                        ChatAdapter.this.checkRequireUserInfo(ChatAdapter.this.userInfoItem.getTimestamp());
                    }
                });
            }
        }
    }
}

