/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.camera;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RxImageConverters {
    public static Observable<File> uriToFile(final Context context, final Uri uri, final File file) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<File>(){

            public void call(Subscriber<? super File> subscriber) {
                try {
                    InputStream inputStream = context.getContentResolver().openInputStream(uri);
                    RxImageConverters.copyInputStreamToFile(inputStream, file);
                    subscriber.onNext((Object)file);
                    subscriber.onCompleted();
                }
                catch (Exception e) {
                    Log.e((String)RxImageConverters.class.getSimpleName(), (String)"Error converting uri", (Throwable)e);
                    subscriber.onError((Throwable)e);
                }
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread());
    }

    public static Observable<Bitmap> uriToBitmap(final Context context, final Uri uri) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Bitmap>(){

            public void call(Subscriber<? super Bitmap> subscriber) {
                try {
                    Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)context.getContentResolver(), (Uri)uri);
                    subscriber.onNext((Object)bitmap);
                    subscriber.onCompleted();
                }
                catch (IOException e) {
                    Log.e((String)RxImageConverters.class.getSimpleName(), (String)"Error converting uri", (Throwable)e);
                    subscriber.onError((Throwable)e);
                }
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread());
    }

    private static void copyInputStreamToFile(InputStream in, File file) throws IOException {
        int len;
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[10240];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        in.close();
    }
}

