package com.zoyi.channel.plugin.android.wrapper;

import android.app.Activity;
import android.app.Application;

import com.splunk.mint.Mint;
import com.zoyi.channel.plugin.android.BuildConfig;

import java.util.HashMap;

public class BugTrace {

  private void init(Activity activity) {
    init(activity.getApplication());
  }

  private void init(Application application) {
    if (application != null) {
      Mint.disableNetworkMonitoring();
      Mint.initAndStartSession(application, "22464da6");
      Mint.addExtraData("plugin_version", BuildConfig.VERSION_NAME);
    }
  }

  private void release(Activity activity) {
    release(activity.getApplication());
  }

  private void release(Application application) {
    if (application != null) {
      Mint.clearExtraData();
      Mint.closeSession(application);
      Mint.flush();
    }
  }

  public static void logException(Exception e) {
    Mint.logException(e);
  }

  public static void logException(String key, String value, Exception e) {
    Mint.logException(key, value, e);
  }

  public static void logException(HashMap<String, Object> datas, Exception e) {
    Mint.logException(datas, e);
  }
}
