package com.zoyi.channel.plugin.android.util;

import com.zoyi.channel.plugin.android.util.lang.DateUtils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

/**
 * Created by mika on 2016. 1. 21..
 */
public class TimeUtils {
  public final static SimpleDateFormat FULL_YEAR = new SimpleDateFormat("yyyy", Locale.getDefault());
  public final static SimpleDateFormat FULL_DAY = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
  public final static SimpleDateFormat FULL_MINUTE = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.getDefault());

  public final static SimpleDateFormat SIMPLE_DAY = new SimpleDateFormat("yyyy-M-d", Locale.getDefault());
  public final static SimpleDateFormat SIMPLE_DATE = new SimpleDateFormat("M/d", Locale.getDefault());
  public final static SimpleDateFormat SIMPLE_YEAR = new SimpleDateFormat("yy/M/d", Locale.getDefault());
  public final static SimpleDateFormat SECOND = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
  public final static SimpleDateFormat MINUTE_24 = new SimpleDateFormat("H:mm", Locale.getDefault());
  public final static SimpleDateFormat MINUTE_12 = new SimpleDateFormat("h:mm", Locale.getDefault());

  public final static Long MAX_MICROSECONDS = 10000000000000000L;
  public static long OFFSET = 0L;

  public static String get(SimpleDateFormat format, Long ts) { return get(format, new Date(ts)); }
  public static String get(SimpleDateFormat format, Date date) { return format.format(date); }
  public static String get(Long ts) {
    if (ts == null) {
      return "";
    }

    Date date = new Date(ts);
    Date now = new Date(System.currentTimeMillis());

    if (DateUtils.isSameDay(now, date)) {
      return getTime(date);
    }

    Calendar cal1 = Calendar.getInstance();
    cal1.setTime(date);
    Calendar cal2 = Calendar.getInstance();
    cal2.setTime(now);

    int year1 = cal1.get(Calendar.YEAR) - 1900;
    int year2 = cal2.get(Calendar.YEAR) - 1900;

    if (year1 == year2) {
      return get(SIMPLE_DATE, date);
    }
    return get(FULL_DAY, date);
  }

  public static String getTime(Long ts) {
    return getTime(new Date(ts));
  }

  public static String getTime(Date date) {
    /*
    if (DateFormat.is24HourFormat(ChannelPlugin.getContext())) {
      return getScript(MINUTE_24, date);
    }
    */

    Calendar cal = Calendar.getInstance();
    cal.setTime(date);

    String time = get(MINUTE_12, date);
    return String.format("%s%s", time, cal.get(Calendar.AM_PM) == Calendar.PM ? "pm" : "am");
  }

  public static String getFullYear(Long ts) {
    String date = TimeUtils.get(TimeUtils.SIMPLE_DAY, ts);
    String time = TimeUtils.getTime(ts);

    return String.format("%s %s", date, time);
  }
}
