package com.zoyi.channel.plugin.android.enumerate;

import com.zoyi.channel.plugin.android.R;

/**
 * Created by mika on 2016. 4. 14..
 */
public enum ActionType {
  DONE(3),
  MORE(4),
  BACK(5),
  EXIT(6),
  CAMERA(7),
  REFRESH(8);

  private int value;
  ActionType(int value) {
    this.value = value;
  }

  public int getIcon() {
    if (value == DONE.value) {
      return R.drawable.ch_plugin_ic_done_white_24dp;
    }
    if (value == MORE.value) {
      return R.drawable.ch_plugin_menu;
    }
    if (value == BACK.value) {
      return R.drawable.ch_plugin_chevron_left;
    }
    if (value == EXIT.value) {
      return R.drawable.ch_plugin_exit_white;
    }
    if (value == CAMERA.value) {
      return R.drawable.ch_plugin_ic_photo_camera_white_24dp;
    }
    if (value == REFRESH.value) {
      return R.drawable.ch_plugin_bar_refresh;
    }
    return 0;
  }
}
