package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.CountryDictionary;
import com.zoyi.channel.plugin.android.activity.chat.listener.UserInfoListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumberItem;
import com.zoyi.channel.plugin.android.activity.chat.model.UserInfoItem;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

/**
 * Created by mika on 2017. 2. 7..
 */
public class UserInfoMessageHolder extends RecyclerView.ViewHolder implements View.OnClickListener {
  private Context context;
  private TextView title, errorTitle, description, agreement, country;
  private LinearLayout inputLayouts, nameLayout, phoneLayout, countryLayout;
  private WatchedEditText nameEdit, phoneEdit;
  private Button nameButton, phoneButton;

  private CountryDictionary countryDictionary;
  private UserInfoListener listener;

  private String code, mobileNumber;
  private boolean handle = false;

  public UserInfoMessageHolder(
      View itemView,
      CountryDictionary countryDictionary,
      final UserInfoListener listener) {
    super(itemView);

    context = itemView.getContext();
    this.countryDictionary = countryDictionary;

    title = (TextView) itemView.findViewById(R.id.user_info_title);
    errorTitle = (TextView) itemView.findViewById(R.id.user_info_error_title);
    description = (TextView) itemView.findViewById(R.id.user_info_description);
    agreement = (TextView) itemView.findViewById(R.id.user_info_agreement);

    inputLayouts = (LinearLayout) itemView.findViewById(R.id.user_info_layout);
    nameLayout = (LinearLayout) itemView.findViewById(R.id.user_info_layout_name);
    phoneLayout = (LinearLayout) itemView.findViewById(R.id.user_info_layout_phone);

    nameEdit = (WatchedEditText) itemView.findViewById(R.id.user_info_layout_name_input);
    nameButton = (Button) itemView.findViewById(R.id.user_info_layout_name_button);

    country = (TextView) itemView.findViewById(R.id.user_info_layout_phone_country);
    countryLayout = (LinearLayout) itemView.findViewById(R.id.user_info_layout_phone_country_layout);
    phoneEdit = (WatchedEditText) itemView.findViewById(R.id.user_info_layout_phone_input);
    phoneButton = (Button) itemView.findViewById(R.id.user_info_layout_phone_button);

    nameEdit.setHandledButton(nameButton, R.color.cobalt, R.color.light);
    nameEdit.setWatchedTextChangedListener(new EditTextChangedListener() {
      @Override
      public void onWatchedTextChanged(String s) {
        if (listener != null && handle) {
          listener.userInfoChanged(s);
        }
      }
    });
    phoneEdit.setHandledButton(phoneButton, R.color.cobalt, R.color.light);
    phoneEdit.setWatchedTextChangedListener(new EditTextChangedListener() {
      @Override
      public void onWatchedTextChanged(String s) {
        if (listener != null && handle) {
          listener.userInfoChanged(new MobileNumberItem(code, s));
        }
        mobileNumber = s;
      }
    });

    nameButton.setOnClickListener(this);
    phoneButton.setOnClickListener(this);
    countryLayout.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        showCountryDialog();
      }
    });

    agreement.setText(Html.fromHtml(ResUtils.getString(context, "ch.agreement")));
    code = "";
    mobileNumber = "";

    this.listener = listener;
  }

  private void initLayout(UserInfoItem item) {
    title.setVisibility(UIUtils.getVisible(!item.isError(), true));
    errorTitle.setVisibility(UIUtils.getVisible(item.isError(), true));

    for (int i = 0; i < inputLayouts.getChildCount(); i++) {
      inputLayouts.getChildAt(i).setVisibility(View.GONE);
    }

    switch (item.getUserInfoType()) {
      case NAME:
        nameLayout.setVisibility(View.VISIBLE);
        break;

      case MOBILE_NUMBER:
        phoneLayout.setVisibility(View.VISIBLE);
        break;
    }
  }

  private String getString(String string) {
    return ResUtils.getString(context, string);
  }

  public void set(UserInfoItem item) {
    L.i("UserInfoMessageHolder.set");
    initLayout(item);
    handle = true;

    switch (item.getUserInfoType()) {
      case NAME:
        if (item.isError()) {
          errorTitle.setText(getString("ch.name_verification.title"));
          description.setText(getString("ch.name_verification.description"));
        } else {
          title.setText(getString("ch.name_verification.title"));
          description.setText(getString("ch.name_verification.description"));
        }

        if (item.getObject() != null && item.getObject() instanceof String) {
          String name = (String) item.getObject();
          nameEdit.setText(name);
        }
        break;

      case MOBILE_NUMBER:
        if (item.isError()) {
          errorTitle.setText(getString("ch.mobile_verification.error.title"));
          description.setText(getString("ch.mobile_verification.error.description"));
        } else {
          title.setText(getString("ch.mobile_verification.title"));
          description.setText(getString("ch.mobile_verification.description"));
        }

        if (item.getObject() != null && item.getObject() instanceof MobileNumberItem) {
          MobileNumberItem mobileNumberItem = (MobileNumberItem) item.getObject();

          code = mobileNumberItem.getCountry();
          mobileNumber = mobileNumberItem.getMobileNumber();

          country.setText(String.format("+%s", mobileNumberItem.getCountry()));
          phoneEdit.setText(mobileNumberItem.getMobileNumber());
        }
        break;
    }
  }

  private void showCountryDialog() {
    ArrayAdapter<String> adapter = new ArrayAdapter<>(context, android.R.layout.select_dialog_item);
    adapter.addAll(countryDictionary.getCountryNames());
    AlertDialog.Builder builder = new AlertDialog.Builder(context)
        .setCancelable(true)
        .setAdapter(adapter, new DialogInterface.OnClickListener() {
          @Override
          public void onClick(DialogInterface dialog, int which) {
            countrySelected(countryDictionary.getCode(which));
          }
        });
    try {
      builder.show();
    } catch (Exception ex) {
      L.e(ex.getMessage());
    }
  }

  private void countrySelected(String code) {
    country.setText(String.format("+%s", code));
    this.code = code;
    if (listener != null && handle) {
      listener.userInfoChanged(new MobileNumberItem(code, mobileNumber));
    }
  }

  @Override
  public void onClick(View v) {
    if (listener != null && handle) {
      listener.apply();
    }
  }
}
