package com.zoyi.channel.plugin.android.activity.camera;

/**
 * Created by mika on 2016. 4. 27..
 */

import android.Manifest;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.global.Const;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class HiddenActivity extends BaseActivity {
  private static final String KEY_CAMERA_PICTURE_URL = "cameraPictureUrl";
  private Uri cameraPictureUrl;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    if (savedInstanceState == null) {
      handleIntent(getIntent());
    }
  }

  @Override
  protected void onSaveInstanceState(Bundle outState) {
    outState.putParcelable(KEY_CAMERA_PICTURE_URL, cameraPictureUrl);
    super.onSaveInstanceState(outState);
  }

  @Override
  protected void onRestoreInstanceState(Bundle savedInstanceState) {
    super.onRestoreInstanceState(savedInstanceState);
    cameraPictureUrl = savedInstanceState.getParcelable(KEY_CAMERA_PICTURE_URL);
  }

  @Override
  protected void onNewIntent(Intent intent) {
    handleIntent(intent);
  }

  @Override
  public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    if (grantResults.length > 0
        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
      handleIntent(getIntent());
    } else {
      finish();
    }
  }

  @Override
  protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    if (resultCode == RESULT_OK) {
      switch (requestCode) {
        case Const.TAKE_PHOTO_REQUEST_CODE:
          if (cameraPictureUrl != null) {
            RxImagePicker.with(this).onImagePicked(getRealPathFromURI(this, cameraPictureUrl));
          }
          break;
      }
    }
    finish();
  }

  private void handleIntent(Intent intent) {
    if (!checkPermission()) {
      return;
    }

    cameraPictureUrl = createImageUri();
    Intent pictureChooseIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
    pictureChooseIntent.putExtra(MediaStore.EXTRA_OUTPUT, cameraPictureUrl);

    startActivityForResult(pictureChooseIntent, Const.TAKE_PHOTO_REQUEST_CODE);
  }

  private String getRealPathFromURI(Context context, Uri contentUri) {
    Cursor cursor = null;
    try {
      String[] proj = { MediaStore.Images.Media.DATA };
      cursor = context.getContentResolver().query(contentUri,  proj, null, null, null);
      if (cursor != null) {
        int column_index = cursor.getColumnIndexOrThrow(MediaStore.Images.Media.DATA);
        cursor.moveToFirst();
        return cursor.getString(column_index);
      }
    } catch (Exception ignored) {
    } {
      if (cursor != null) {
        cursor.close();
      }
    }

    return null;
  }

  private boolean checkPermission() {
    if (ContextCompat.checkSelfPermission(
        HiddenActivity.this,
        Manifest.permission.WRITE_EXTERNAL_STORAGE)
        != PackageManager.PERMISSION_GRANTED) {
      ActivityCompat.requestPermissions(
          HiddenActivity.this,
          new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE},
          0);
      return false;
    } else {
      return true;
    }
  }

  private Uri createImageUri() {
    String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
    String filePath = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DCIM)
        + "/Camera/" + timeStamp + ".jpg";

    ContentResolver contentResolver = getContentResolver();
    ContentValues values = new ContentValues();

    values.put(MediaStore.Images.Media.TITLE, timeStamp);
    values.put(MediaStore.Images.ImageColumns.DISPLAY_NAME, timeStamp + ".jpg");
    values.put(MediaStore.Images.Media.MIME_TYPE, "image/jpeg");
    values.put(MediaStore.Images.ImageColumns.DATA, filePath);
    values.put(MediaStore.Images.ImageColumns.DATE_TAKEN, System.currentTimeMillis());
    return contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
  }
}