/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.MissingBackpressureException;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.producers.ProducerArbiter;
import com.zoyi.rx.internal.util.ExceptionsUtils;
import com.zoyi.rx.internal.util.ScalarSynchronousObservable;
import com.zoyi.rx.internal.util.atomic.SpscAtomicArrayQueue;
import com.zoyi.rx.internal.util.unsafe.SpscArrayQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import com.zoyi.rx.observers.SerializedSubscriber;
import com.zoyi.rx.plugins.RxJavaHooks;
import com.zoyi.rx.subscriptions.SerialSubscription;
import java.util.AbstractQueue;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class OnSubscribeConcatMap<T, R>
implements Observable.OnSubscribe<R> {
    final Observable<? extends T> source;
    final Func1<? super T, ? extends Observable<? extends R>> mapper;
    final int prefetch;
    final int delayErrorMode;
    public static final int IMMEDIATE = 0;
    public static final int BOUNDARY = 1;
    public static final int END = 2;

    public OnSubscribeConcatMap(Observable<? extends T> source, Func1<? super T, ? extends Observable<? extends R>> mapper, int prefetch, int delayErrorMode) {
        this.source = source;
        this.mapper = mapper;
        this.prefetch = prefetch;
        this.delayErrorMode = delayErrorMode;
    }

    @Override
    public void call(Subscriber<? super R> child) {
        Subscriber s = this.delayErrorMode == 0 ? new SerializedSubscriber<R>(child) : child;
        final ConcatMapSubscriber<? super T, ? super R> parent = new ConcatMapSubscriber<T, R>(s, this.mapper, this.prefetch, this.delayErrorMode);
        child.add(parent);
        child.add(parent.inner);
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                parent.requestMore(n);
            }
        });
        if (!child.isUnsubscribed()) {
            this.source.unsafeSubscribe(parent);
        }
    }

    static final class ConcatMapInnerScalarProducer<T, R>
    implements Producer {
        final R value;
        final ConcatMapSubscriber<T, R> parent;
        boolean once;

        public ConcatMapInnerScalarProducer(R value, ConcatMapSubscriber<T, R> parent) {
            this.value = value;
            this.parent = parent;
        }

        @Override
        public void request(long n) {
            if (!this.once && n > 0L) {
                this.once = true;
                ConcatMapSubscriber<T, R> p = this.parent;
                p.innerNext(this.value);
                p.innerCompleted(1L);
            }
        }
    }

    static final class ConcatMapInnerSubscriber<T, R>
    extends Subscriber<R> {
        final ConcatMapSubscriber<T, R> parent;
        long produced;

        public ConcatMapInnerSubscriber(ConcatMapSubscriber<T, R> parent) {
            this.parent = parent;
        }

        @Override
        public void setProducer(Producer p) {
            this.parent.arbiter.setProducer(p);
        }

        @Override
        public void onNext(R t) {
            ++this.produced;
            this.parent.innerNext(t);
        }

        @Override
        public void onError(Throwable e) {
            this.parent.innerError(e, this.produced);
        }

        @Override
        public void onCompleted() {
            this.parent.innerCompleted(this.produced);
        }
    }

    static final class ConcatMapSubscriber<T, R>
    extends Subscriber<T> {
        final Subscriber<? super R> actual;
        final Func1<? super T, ? extends Observable<? extends R>> mapper;
        final int delayErrorMode;
        final ProducerArbiter arbiter;
        final Queue<Object> queue;
        final AtomicInteger wip;
        final AtomicReference<Throwable> error;
        final SerialSubscription inner;
        volatile boolean done;
        volatile boolean active;

        public ConcatMapSubscriber(Subscriber<? super R> actual, Func1<? super T, ? extends Observable<? extends R>> mapper, int prefetch, int delayErrorMode) {
            this.actual = actual;
            this.mapper = mapper;
            this.delayErrorMode = delayErrorMode;
            this.arbiter = new ProducerArbiter();
            this.wip = new AtomicInteger();
            this.error = new AtomicReference();
            AbstractQueue q = UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue(prefetch) : new SpscAtomicArrayQueue(prefetch);
            this.queue = q;
            this.inner = new SerialSubscription();
            this.request(prefetch);
        }

        @Override
        public void onNext(T t) {
            if (!this.queue.offer(NotificationLite.instance().next(t))) {
                this.unsubscribe();
                this.onError(new MissingBackpressureException());
            } else {
                this.drain();
            }
        }

        @Override
        public void onError(Throwable mainError) {
            if (ExceptionsUtils.addThrowable(this.error, mainError)) {
                this.done = true;
                if (this.delayErrorMode == 0) {
                    Throwable ex = ExceptionsUtils.terminate(this.error);
                    if (!ExceptionsUtils.isTerminated(ex)) {
                        this.actual.onError(ex);
                    }
                    this.inner.unsubscribe();
                } else {
                    this.drain();
                }
            } else {
                this.pluginError(mainError);
            }
        }

        @Override
        public void onCompleted() {
            this.done = true;
            this.drain();
        }

        void requestMore(long n) {
            if (n > 0L) {
                this.arbiter.request(n);
            } else if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required but it was " + n);
            }
        }

        void innerNext(R value) {
            this.actual.onNext(value);
        }

        void innerError(Throwable innerError, long produced) {
            if (!ExceptionsUtils.addThrowable(this.error, innerError)) {
                this.pluginError(innerError);
            } else if (this.delayErrorMode == 0) {
                Throwable ex = ExceptionsUtils.terminate(this.error);
                if (!ExceptionsUtils.isTerminated(ex)) {
                    this.actual.onError(ex);
                }
                this.unsubscribe();
            } else {
                if (produced != 0L) {
                    this.arbiter.produced(produced);
                }
                this.active = false;
                this.drain();
            }
        }

        void innerCompleted(long produced) {
            if (produced != 0L) {
                this.arbiter.produced(produced);
            }
            this.active = false;
            this.drain();
        }

        void pluginError(Throwable e) {
            RxJavaHooks.onError(e);
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int delayErrorMode = this.delayErrorMode;
            while (true) {
                if (this.actual.isUnsubscribed()) {
                    return;
                }
                if (!this.active) {
                    boolean empty;
                    if (delayErrorMode == 1 && this.error.get() != null) {
                        Throwable ex = ExceptionsUtils.terminate(this.error);
                        if (!ExceptionsUtils.isTerminated(ex)) {
                            this.actual.onError(ex);
                        }
                        return;
                    }
                    boolean mainDone = this.done;
                    Object v = this.queue.poll();
                    boolean bl = empty = v == null;
                    if (mainDone && empty) {
                        Throwable ex = ExceptionsUtils.terminate(this.error);
                        if (ex == null) {
                            this.actual.onCompleted();
                        } else if (!ExceptionsUtils.isTerminated(ex)) {
                            this.actual.onError(ex);
                        }
                        return;
                    }
                    if (!empty) {
                        Observable<R> source;
                        try {
                            source = this.mapper.call(NotificationLite.instance().getValue(v));
                        }
                        catch (Throwable mapperError) {
                            Exceptions.throwIfFatal(mapperError);
                            this.drainError(mapperError);
                            return;
                        }
                        if (source == null) {
                            this.drainError(new NullPointerException("The source returned by the mapper was null"));
                            return;
                        }
                        if (source != Observable.empty()) {
                            if (source instanceof ScalarSynchronousObservable) {
                                ScalarSynchronousObservable scalarSource = (ScalarSynchronousObservable)source;
                                this.active = true;
                                this.arbiter.setProducer(new ConcatMapInnerScalarProducer(scalarSource.get(), this));
                            } else {
                                ConcatMapInnerSubscriber innerSubscriber = new ConcatMapInnerSubscriber(this);
                                this.inner.set(innerSubscriber);
                                if (!innerSubscriber.isUnsubscribed()) {
                                    this.active = true;
                                    source.unsafeSubscribe(innerSubscriber);
                                } else {
                                    return;
                                }
                            }
                            this.request(1L);
                        } else {
                            this.request(1L);
                            continue;
                        }
                    }
                }
                if (this.wip.decrementAndGet() == 0) break;
            }
        }

        void drainError(Throwable mapperError) {
            this.unsubscribe();
            if (ExceptionsUtils.addThrowable(this.error, mapperError)) {
                Throwable ex = ExceptionsUtils.terminate(this.error);
                if (!ExceptionsUtils.isTerminated(ex)) {
                    this.actual.onError(ex);
                }
            } else {
                this.pluginError(mapperError);
            }
        }
    }
}

