/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.com.bumptech.glide.DrawableRequestBuilder;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

public class AvatarLayout
extends FrameLayout {
    Context context;
    ImageView back;
    ImageView image;
    TextView text;

    public AvatarLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public AvatarLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AvatarLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public AvatarLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(Context context, AttributeSet attrs) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_avatar, (ViewGroup)this);
        this.back = (ImageView)view.findViewById(R.id.back_profile);
        this.image = (ImageView)view.findViewById(R.id.image_profile);
        this.text = (TextView)view.findViewById(R.id.text_profile);
        int textSize = 16;
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AvatarLayout, 0, 0);
            try {
                textSize = typedArray.getDimensionPixelSize(R.styleable.AvatarLayout_initialSize, textSize);
            }
            finally {
                typedArray.recycle();
            }
        }
        this.text.setTextSize(0, (float)textSize);
    }

    private void reset(boolean isImage) {
        if (isImage) {
            this.back.setBackgroundColor(-1);
            this.image.setVisibility(0);
            this.text.setVisibility(8);
        } else {
            this.image.setVisibility(8);
            this.text.setVisibility(0);
        }
    }

    public void set(ProfileEntity entity) {
        if (entity == null) {
            this.reset(false);
            this.back.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.dark));
            this.text.setTextColor(-1);
            this.text.setText((CharSequence)"?");
        } else if (entity.getAvatarUrl() != null) {
            this.reset(true);
            ((DrawableRequestBuilder)((DrawableRequestBuilder)((DrawableRequestBuilder)Glide.with(this.getContext()).load(entity.getAvatarUrl()).centerCrop()).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.RESULT)).into(this.image);
        } else {
            this.reset(false);
            this.back.setBackgroundColor(entity.getBackgroundColor());
            this.text.setTextColor(entity.getTextColor());
            this.text.setText((CharSequence)entity.getInitial());
        }
    }

    public void setTextSize(int size) {
        this.text.setTextSize(2, (float)size);
    }
}

