/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.model.rest.TimeRange;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class WorkingTime {
    private TimeRange sun;
    private TimeRange mon;
    private TimeRange tue;
    private TimeRange wed;
    private TimeRange thu;
    private TimeRange fri;
    private TimeRange sat;

    public String getMessage() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Utils.getString((Context)ChannelPlugin.getApplication(), "ch.out_of_work.title"));
        this.addTimeRange(list, "sun", this.sun);
        this.addTimeRange(list, "mon", this.mon);
        this.addTimeRange(list, "tue", this.tue);
        this.addTimeRange(list, "wed", this.wed);
        this.addTimeRange(list, "thu", this.thu);
        this.addTimeRange(list, "fri", this.fri);
        this.addTimeRange(list, "sat", this.sat);
        return StringUtils.join(list, "\n\n");
    }

    private void addTimeRange(List<String> list, String key, TimeRange timeRange) {
        if (timeRange == null || timeRange.getFrom() == null || timeRange.getTo() == null) {
            return;
        }
        String title = Utils.getString((Context)ChannelPlugin.getApplication(), "ch.out_of_work." + key);
        String content = this.getTimeRangeString(timeRange);
        list.add(String.format("%s\n%s", title, content));
    }

    private String getTimeRangeString(TimeRange timeRange) {
        return String.format("%s ~ %s", this.getTime(timeRange.getFrom()), this.getTime(timeRange.getTo()));
    }

    private String getTime(int time) {
        time = Math.max(time, 0);
        time = Math.min(time, 1439);
        int hour = time / 60;
        int minute = time % 60;
        String add = hour < 12 ? "AM" : "PM";
        return String.format("%02d:%02d %s", hour > 12 ? hour - 12 : hour, minute, add);
    }
}

