/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatItem;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import java.util.List;

public class UserChatHolder
extends RecyclerView.ViewHolder {
    Context context;
    View singleAvatar;
    View doubleAvatar;
    View tripleAvatar;
    AvatarLayout avatarSingle;
    AvatarLayout avatarDouble1;
    AvatarLayout avatarDouble2;
    AvatarLayout avatarTriple1;
    AvatarLayout avatarTriple2;
    AvatarLayout avatarTriple3;
    TextView textName;
    TextView textTime;
    TextView textMessage;
    TextView textBadge;
    UserChat userChat;

    public UserChatHolder(View itemView) {
        super(itemView);
        this.context = itemView.getContext();
        this.singleAvatar = itemView.findViewById(R.id.layout_single);
        this.doubleAvatar = itemView.findViewById(R.id.layout_double);
        this.tripleAvatar = itemView.findViewById(R.id.layout_triple);
        this.avatarSingle = (AvatarLayout)itemView.findViewById(R.id.avatar_single);
        this.avatarDouble1 = (AvatarLayout)itemView.findViewById(R.id.avatar_double1);
        this.avatarDouble2 = (AvatarLayout)itemView.findViewById(R.id.avatar_double2);
        this.avatarTriple1 = (AvatarLayout)itemView.findViewById(R.id.avatar_triple1);
        this.avatarTriple2 = (AvatarLayout)itemView.findViewById(R.id.avatar_triple2);
        this.avatarTriple3 = (AvatarLayout)itemView.findViewById(R.id.avatar_triple3);
        this.avatarSingle.setTextSize(16);
        this.avatarDouble1.setTextSize(14);
        this.avatarDouble2.setTextSize(14);
        this.avatarTriple1.setTextSize(10);
        this.avatarTriple2.setTextSize(10);
        this.avatarTriple3.setTextSize(10);
        this.textName = (TextView)itemView.findViewById(R.id.text_name);
        this.textTime = (TextView)itemView.findViewById(R.id.text_time);
        this.textMessage = (TextView)itemView.findViewById(R.id.text_message);
        this.textBadge = (TextView)itemView.findViewById(R.id.text_badge);
    }

    public void setUserChatItem(UserChatItem item) {
        this.userChat = item.getUserChat();
        Message message = item.getMessage();
        Session session = item.getSession();
        List<? extends ProfileEntity> profiles = item.getProfiles();
        this.textName.setText((CharSequence)UIUtils.getNamesString(profiles));
        if (message != null) {
            if (message.getFile() == null && message.getMessage() != null) {
                this.textMessage.setText((CharSequence)message.getMessage());
            } else {
                this.textMessage.setText((CharSequence)Utils.getString(this.context, "ch.notification.upload_file.description"));
            }
        } else {
            this.textMessage.setText((CharSequence)"");
        }
        if (this.userChat != null && this.userChat.getUpdatedAt() != null) {
            this.textTime.setText((CharSequence)TimeUtils.get(this.userChat.getUpdatedAt()));
        } else {
            this.textTime.setText((CharSequence)"");
        }
        if (session != null && session.getAlert() != null && session.getAlert() > 0) {
            this.textBadge.setVisibility(0);
            this.textBadge.setText((CharSequence)Utils.getCount(session.getAlert(), true));
        } else {
            this.textBadge.setVisibility(8);
        }
        this.singleAvatar.setVisibility(8);
        this.doubleAvatar.setVisibility(8);
        this.tripleAvatar.setVisibility(8);
        if (profiles.size() == 1) {
            this.singleAvatar.setVisibility(0);
            this.avatarSingle.set(profiles.get(0));
        } else if (profiles.size() == 2) {
            this.doubleAvatar.setVisibility(0);
            this.avatarDouble1.set(profiles.get(0));
            this.avatarDouble2.set(profiles.get(1));
        } else if (profiles.size() > 2) {
            this.tripleAvatar.setVisibility(0);
            this.avatarTriple1.set(profiles.get(0));
            this.avatarTriple2.set(profiles.get(1));
            this.avatarTriple3.set(profiles.get(2));
        }
    }

    public String getChatId() {
        if (this.userChat != null) {
            return this.userChat.getId();
        }
        return null;
    }
}

