/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.camera.RxImagePicker;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerAdapter;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoProcessListener;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.MenuPosition;
import com.zoyi.channel.plugin.android.enumerate.MenuState;
import com.zoyi.channel.plugin.android.model.wrapper.MarginBox;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.rx.functions.Action1;
import java.util.ArrayList;

public class PhotoPickerActivity
extends BaseActivity
implements PhotoProcessListener {
    RecyclerView recyclerView;
    LinearLayout emptyLayout;
    int photoMargin;
    private PhotoPickerAdapter adapter;
    private int columns;
    private boolean init;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_photo_picker);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_view_photo_picker);
        this.emptyLayout = (LinearLayout)this.findViewById(R.id.no_album);
        this.photoMargin = (int)Utils.dpToPx((Context)this, 2.0f);
        this.getBigBar().withActivity(this).addMenu(ActionType.BACK, MenuPosition.LEFT).addMenu(ActionType.CAMERA, MenuPosition.RIGHT).addMenu(ActionType.DONE, MenuPosition.RIGHT, MenuState.DISABLED).build();
        this.adapter = new PhotoPickerAdapter(this, R.layout.ch_plugin_item_photo_picker, this);
        this.orientationBasedUI(this.getResources().getConfiguration().orientation);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recyclerView.setItemAnimator(null);
        this.showLoading();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.orientationBasedUI(newConfig.orientation);
    }

    protected void onResume() {
        super.onResume();
        if (!this.init) {
            this.init = true;
            this.refreshData();
        }
    }

    public void onBackPressed() {
        this.setResult(0);
        super.onBackPressed();
    }

    private void orientationBasedUI(int orientation) {
        WindowManager windowManager = (WindowManager)this.getApplicationContext().getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(metrics);
        this.columns = orientation == 1 ? 3 : 5;
        GridLayoutManager layoutManager = new GridLayoutManager((Context)this, this.columns);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        if (this.adapter != null) {
            int size = metrics.widthPixels / this.columns;
            this.adapter.setImageSize(size);
        }
    }

    private void refreshData() {
        if (this.checkPermission(2)) {
            this.adapter.startFetchPhoto();
        }
    }

    private void showLoading() {
        this.recyclerView.setVisibility(8);
        this.emptyLayout.setVisibility(8);
    }

    private void hideLoading() {
        this.recyclerView.setVisibility(0);
        this.emptyLayout.setVisibility(8);
    }

    private void showEmpty() {
        this.recyclerView.setVisibility(8);
        this.emptyLayout.setVisibility(0);
    }

    @Override
    protected void permissionAccepted(int requestCode) {
        if (requestCode == 2) {
            this.refreshData();
        } else if (requestCode == 3) {
            this.openCamera();
        }
    }

    @Override
    protected void permissionRejected(int requestCode) {
        if (requestCode == 2) {
            this.finish();
        }
    }

    @Override
    public void photoFetchSucceeded(int count) {
        if (count == 0) {
            this.showEmpty();
        } else {
            this.hideLoading();
        }
    }

    @Override
    public void photoFetchFailed() {
        this.showEmpty();
    }

    @Override
    public void onePhotoSelected(String path) {
        this.finish();
    }

    private void photoSelected(ArrayList<String> list) {
        Intent i = new Intent();
        i.putStringArrayListExtra("PHOTO_INTENT_KEY", list);
        this.setResult(12, i);
        this.finish();
    }

    @Override
    public void photoSelected(int count) {
        this.getBigBar().setMenuState(ActionType.DONE, count > 0 ? MenuState.VISIBLE : MenuState.DISABLED);
    }

    @Override
    public MarginBox getMargin(int index) {
        if (index < this.columns) {
            return new MarginBox(this.photoMargin, this.photoMargin * 2, this.photoMargin, this.photoMargin * 2);
        }
        return new MarginBox(this.photoMargin, 0, this.photoMargin, this.photoMargin * 2);
    }

    @Override
    public void optionClicked(ActionType actionType) {
        super.optionClicked(actionType);
        switch (actionType) {
            case BACK: {
                this.onBackPressed();
                break;
            }
            case CAMERA: {
                this.openCamera();
                break;
            }
            case DONE: {
                this.photoSelected(this.adapter.getSelectedNames());
            }
        }
    }

    private void openCamera() {
        if (this.checkPermission(3)) {
            RxImagePicker.with((Context)this).requestImage().subscribe((Action1)new Action1<String>(){

                public void call(String s) {
                    if (s != null) {
                        ArrayList<String> singleton = new ArrayList<String>();
                        singleton.add(s);
                        PhotoPickerActivity.this.photoSelected(singleton);
                    }
                }
            });
        }
    }
}

