/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.content.Context;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Script;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.Veil;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ScriptsWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ChannelStore {
    private static Subscription subscription;
    private static Map<String, Script> scriptMap;
    static Channel channel;
    static String veilId;
    static User user;
    static Veil veil;

    static void startFetchPlugin() {
        ChannelStore.stopFetchPlugin();
        subscription = Observable.interval((long)3L, (TimeUnit)TimeUnit.MINUTES).subscribe((Subscriber)new Subscriber<Long>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Long aLong) {
                ChannelStore.fetchPlugin();
            }
        });
    }

    static void stopFetchPlugin() {
        if (subscription != null && !subscription.isUnsubscribed()) {
            subscription.unsubscribe();
        }
    }

    private static void fetchPlugin() {
        if (ChannelPlugin.pluginId != null) {
            ChannelPlugin.getService().getPlugin(ChannelPlugin.pluginId).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<PluginWrapper>(){

                @Override
                public void onNext(PluginWrapper pluginWrapper) {
                    if (pluginWrapper != null) {
                        channel = pluginWrapper.getChannel();
                    }
                }
            });
        }
    }

    static void fetchScripts() {
        ChannelPlugin.getService().getScripts().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<ScriptsWrapper>(){

            @Override
            public void onNext(ScriptsWrapper scriptsWrapper) {
                ChannelStore.setScripts(scriptsWrapper.getScripts());
            }
        });
    }

    private static void setScripts(List<Script> scripts) {
        if (scriptMap == null) {
            scriptMap = new HashMap<String, Script>();
        }
        if (scripts != null) {
            scriptMap = new HashMap<String, Script>();
            for (Script script : scripts) {
                if (script.getKey() == null) continue;
                scriptMap.put(script.getKey(), script);
            }
        }
    }

    public static String getScript(String key, String resourceKey) {
        if (scriptMap != null && scriptMap.containsKey(key)) {
            String locale = Locale.getDefault().getLanguage();
            if (scriptMap.get(key).getMessage(locale) != null) {
                return scriptMap.get(key).getMessage(locale);
            }
        }
        if (ChannelPlugin.getApplication() != null) {
            return Utils.getString((Context)ChannelPlugin.getApplication(), resourceKey);
        }
        return "";
    }

    public static String getChannelId() {
        if (channel != null) {
            return channel.getId();
        }
        return null;
    }

    public static Channel getChannel() {
        return channel;
    }

    public static String getUserName() {
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    public static String getMobileNumber() {
        if (user != null) {
            return user.getMobileNumber();
        }
        if (veil != null) {
            return veil.getMobileNumber();
        }
        return null;
    }

    public static String getPersonType() {
        if (user != null) {
            return User.CLASSNAME;
        }
        return Veil.CLASSNAME;
    }

    public static String getPersonId() {
        if (user != null) {
            return user.getId();
        }
        return veilId;
    }

    public static String getVeilId() {
        return veilId;
    }

    public static String getUserId() {
        if (user != null) {
            return user.getId();
        }
        return null;
    }

    public static boolean isWorking() {
        if (channel != null) {
            return channel.isWorking();
        }
        return false;
    }

    public static boolean hasName() {
        if (user != null) {
            return user.isGhost() == false;
        }
        if (veil != null) {
            return !veil.isGhost();
        }
        return true;
    }

    public static void setUserVeil(User user, Veil veil) {
        if (user != null) {
            ChannelStore.user = user;
        }
        if (veil != null) {
            ChannelStore.veil = veil;
        }
    }
}

