package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.R;

/**
 * Created by mika on 2017. 1. 31..
 */
public class ProfileLayout extends LinearLayout {
  private Context context;
  private TextView key, value;

  public ProfileLayout(Context context) {
    super(context);
    init(context, null);
  }

  public ProfileLayout(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  private void init(final Context context, AttributeSet attrs) {
    this.context = context;

    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_item_profile, this);
    key = (TextView) findViewById(R.id.text_key);
    value = (TextView) findViewById(R.id.text_value);
  }

  public void set(String key, String value) {
    this.key.setText(key == null ? "" : key);
    this.value.setText(value == null ? "" : value);
  }
}
