package com.zoyi.channel.plugin.android.network;

import com.zoyi.com.google.gson.*;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.WebPage;

import java.lang.reflect.Type;

/**
 * Created by mika on 2016. 12. 28..
 */
public class MessageDeserializer implements JsonDeserializer<Message> {
  private Gson gson;
  public MessageDeserializer() {
    this.gson = new Gson();
  }

  @Override
  public Message deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
    Message message = gson.fromJson(json, typeOfT);
    if (message != null) {
      if (message.getFile() != null) {
        if (message.getFile().isImage()) {
//          message.setAttachType(Const.IMAGE_FILE);
          if (message.getFile().getPreviewThumb() != null) {
            String newId = String.format("%s:%s", File.class.getSimpleName(), message.getFile().getId());
            message.getFile().getPreviewThumb().setId(newId);
          }
        } else {
//          message.setAttachType(Const.RAW_FILE);
        }
      }
      if (message.getWebPage() != null) {
//        message.setAttachType(Const.WEB_PAGE);
        if (message.getWebPage().getPreviewThumb() != null) {
          String newId = String.format("%s:%s", WebPage.class.getSimpleName(), message.getWebPage().getId());
          message.getWebPage().getPreviewThumb().setId(newId);
        }
      }
    }

    return message;
  }
}
