package com.zoyi.channel.plugin.android.model.rest;

import android.graphics.Color;

/**
 * Created by mika on 2016. 12. 6..
 */
public class Channel extends ProfileEntity {
  private String id;
  private String name;
  private String description;
  private String country;
  private Long createdAt;
  private String domain;
  private String color;
  private String textColor;
  private String userInfoUrl;
  private String timeZone;
  private String initial;
  private String avatarUrl;
  private Boolean working;
  private WorkingTime workingTime;

  public String getId() {
    return id;
  }

  public String getName() {
    return name;
  }

  public String getDescription() {
    return description;
  }

  public String getCountry() {
    return country;
  }

  public Long getCreatedAt() {
    return createdAt;
  }

  public String getDomain() {
    return domain;
  }

  public String getColor() {
    return color;
  }

  public String getUserInfoUrl() {
    return userInfoUrl;
  }

  public String getTimeZone() {
    return timeZone;
  }

  @Override
  public String getPersonType() {
    return this.getClass().getSimpleName();
  }

  @Override
  public int getBackgroundColor() {
    try {
      return Color.parseColor(color);
    } catch (Exception ex) {
    }
    return Color.BLACK;
  }

  @Override
  public int getTextColor() {
    return "black".equals(textColor) ? Color.BLACK : Color.WHITE;
  }

  @Override
  public String getAvatarUrl() {
    return avatarUrl;
  }

  @Override
  public String getInitial() {
    return initial;
  }

  public boolean isWorking() {
    if (working != null) {
      return working;
    }
    return false;
  }

  public final static String CLASSNAME = "Channel";

  public String getWorkingTime() {
    if (workingTime != null) {
      return workingTime.getMessage();
    }
    return "";
  }
}
